/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.extras.actions;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.extras.actions.BaseAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DispatchAction
extends BaseAction {
    private static final long serialVersionUID = 4211198620691041849L;
    private final transient Logger log = LoggerFactory.getLogger(DispatchAction.class);
    protected Class<? extends DispatchAction> clazz = ((Object)((Object)this)).getClass();
    protected HashMap<String, Method> methods = new HashMap();
    protected Class<?>[] types = new Class[]{ActionMapping.class, ActionForm.class, HttpServletRequest.class, HttpServletResponse.class};

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward af;
        if (this.isCancelled(request) && (af = this.cancelled(mapping, form, request, response)) != null) {
            return af;
        }
        String parameter = this.getParameter(mapping, form, request, response);
        String name = this.getMethodName(mapping, form, request, response, parameter);
        if ("execute".equals(name) || "perform".equals(name)) {
            String message = messages.getMessage("dispatch.recursive", (Object)mapping.getPath());
            this.log.error(message);
            throw new ServletException(message);
        }
        return this.dispatchMethod(mapping, form, request, response, name);
    }

    protected ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = messages.getMessage("dispatch.parameter", (Object)mapping.getPath(), (Object)mapping.getParameter());
        this.log.error(message);
        throw new ServletException(message);
    }

    protected ActionForward cancelled(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return null;
    }

    protected ActionForward dispatchMethod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String name) throws Exception {
        if (name == null) {
            return this.unspecified(mapping, form, request, response);
        }
        Method method = null;
        try {
            method = this.getMethod(name);
        }
        catch (NoSuchMethodException e) {
            this.log.atError().setMessage(() -> messages.getMessage("dispatch.method", (Object)mapping.getPath(), (Object)name)).setCause((Throwable)e).log();
            String userMsg = messages.getMessage("dispatch.method.user", (Object)mapping.getPath());
            NoSuchMethodException e2 = new NoSuchMethodException(userMsg);
            e2.initCause(e);
            throw e2;
        }
        ActionForward forward = null;
        try {
            Object[] args = new Object[]{mapping, form, request, response};
            forward = (ActionForward)method.invoke((Object)this, args);
        }
        catch (ClassCastException e) {
            this.log.atError().setMessage(() -> messages.getMessage("dispatch.return", (Object)mapping.getPath(), (Object)name)).setCause((Throwable)e).log();
            throw e;
        }
        catch (IllegalAccessException e) {
            this.log.atError().setMessage(() -> messages.getMessage("dispatch.error", (Object)mapping.getPath(), (Object)name)).setCause((Throwable)e).log();
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            this.log.atError().setMessage(() -> messages.getMessage("dispatch.error", (Object)mapping.getPath(), (Object)name)).setCause((Throwable)e).log();
            throw new ServletException(t);
        }
        return forward;
    }

    protected String getParameter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String parameter = mapping.getParameter();
        if (parameter == null) {
            String message = messages.getMessage("dispatch.handler", (Object)mapping.getPath());
            this.log.error(message);
            throw new ServletException(message);
        }
        return parameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Method getMethod(String name) throws NoSuchMethodException {
        HashMap<String, Method> hashMap = this.methods;
        synchronized (hashMap) {
            Method method = this.methods.get(name);
            if (method == null) {
                method = this.clazz.getMethod(name, this.types);
                this.methods.put(name, method);
            }
            return method;
        }
    }

    protected String getMethodName(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String parameter) throws Exception {
        return request.getParameter(parameter);
    }
}

