/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.extras.actions;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.chain.contexts.ServletActionContext;
import org.apache.struts.dispatcher.Dispatcher;
import org.apache.struts.util.MessageResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionDispatcher
implements Dispatcher {
    private static final long serialVersionUID = 3784151345188637566L;
    public static final int DEFAULT_FLAVOR = 0;
    public static final int MAPPING_FLAVOR = 1;
    public static final int DISPATCH_FLAVOR = 2;
    private final transient Logger log = LoggerFactory.getLogger(ActionDispatcher.class);
    protected static MessageResources messages = MessageResources.getMessageResources((String)"org.apache.struts.extras.actions.LocalStrings");
    protected Action actionInstance;
    protected int flavor;
    protected Class<? extends Action> clazz;
    protected HashMap<String, Method> methods = new HashMap();
    protected Class<?>[] types = new Class[]{ActionMapping.class, ActionForm.class, HttpServletRequest.class, HttpServletResponse.class};

    public ActionDispatcher(Action actionInstance) {
        this(actionInstance, 0);
    }

    public ActionDispatcher(Action actionInstance, int flavor) {
        this.actionInstance = actionInstance;
        this.flavor = flavor;
        this.clazz = actionInstance.getClass();
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward af;
        if (this.isCancelled(request) && (af = this.cancelled(mapping, form, request, response)) != null) {
            return af;
        }
        String parameter = this.getParameter(mapping, form, request, response);
        String name = this.getMethodName(mapping, form, request, response, parameter);
        if ("execute".equals(name) || "perform".equals(name)) {
            String message = messages.getMessage("dispatch.recursive", (Object)mapping.getPath());
            this.log.error(message);
            throw new ServletException(message);
        }
        return this.dispatchMethod(mapping, form, request, response, name);
    }

    protected ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String name = "unspecified";
        Method method = null;
        try {
            method = this.getMethod(name);
        }
        catch (NoSuchMethodException e) {
            String message = messages.getMessage("dispatch.parameter", (Object)mapping.getPath(), (Object)mapping.getParameter());
            this.log.error(message);
            throw new ServletException(message, (Throwable)e);
        }
        return this.dispatchMethod(mapping, form, request, response, name, method);
    }

    protected ActionForward cancelled(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String name = "cancelled";
        Method method = null;
        try {
            method = this.getMethod(name);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return this.dispatchMethod(mapping, form, request, response, name, method);
    }

    protected ActionForward dispatchMethod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String name) throws Exception {
        if (name == null) {
            return this.unspecified(mapping, form, request, response);
        }
        Method method = null;
        try {
            method = this.getMethod(name);
        }
        catch (NoSuchMethodException e) {
            this.log.atError().setMessage(() -> messages.getMessage("dispatch.method", (Object)mapping.getPath(), (Object)name)).setCause((Throwable)e).log();
            String userMsg = messages.getMessage("dispatch.method.user", (Object)mapping.getPath());
            NoSuchMethodException e2 = new NoSuchMethodException(userMsg);
            e2.initCause(e);
            throw e2;
        }
        return this.dispatchMethod(mapping, form, request, response, name, method);
    }

    protected ActionForward dispatchMethod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String name, Method method) throws Exception {
        ActionForward forward = null;
        try {
            Object[] args = new Object[]{mapping, form, request, response};
            forward = (ActionForward)method.invoke((Object)this.actionInstance, args);
        }
        catch (ClassCastException e) {
            this.log.atError().setMessage(() -> messages.getMessage("dispatch.return", (Object)mapping.getPath(), (Object)name)).setCause((Throwable)e).log();
            throw e;
        }
        catch (IllegalAccessException e) {
            this.log.atError().setMessage(() -> messages.getMessage("dispatch.error", (Object)mapping.getPath(), (Object)name)).setCause((Throwable)e).log();
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            this.log.atError().setMessage(() -> messages.getMessage("dispatch.error", (Object)mapping.getPath(), (Object)name)).setCause((Throwable)e).log();
            throw new ServletException(t);
        }
        return forward;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Method getMethod(String name) throws NoSuchMethodException {
        HashMap<String, Method> hashMap = this.methods;
        synchronized (hashMap) {
            Method method = this.methods.get(name);
            if (method == null) {
                method = this.clazz.getMethod(name, this.types);
                this.methods.put(name, method);
            }
            return method;
        }
    }

    protected String getParameter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String parameter = mapping.getParameter();
        if ("".equals(parameter)) {
            parameter = null;
        }
        if (parameter == null && this.flavor == 0) {
            return "method";
        }
        if (parameter == null && (this.flavor == 1 || this.flavor == 2)) {
            String message = messages.getMessage("dispatch.handler", (Object)mapping.getPath());
            this.log.error(message);
            throw new ServletException(message);
        }
        return parameter;
    }

    protected String getMethodName(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String parameter) throws Exception {
        if (this.flavor == 1) {
            return parameter;
        }
        return request.getParameter(parameter);
    }

    protected boolean isCancelled(HttpServletRequest request) {
        return request.getAttribute("org.apache.struts.action.CANCEL") != null;
    }

    public Object dispatch(ActionContext context) throws Exception {
        ServletActionContext servletContext = (ServletActionContext)context;
        return this.execute((ActionMapping)context.getActionConfig(), context.getActionForm(), servletContext.getRequest(), servletContext.getResponse());
    }
}

