/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.ani.util.nix;

import com.ahsay.ani.console.LineCommand;
import com.ahsay.ani.console.LineCommand$Output;
import com.ahsay.ani.util.ComputerInfo;
import com.ahsay.ani.util.StringUtil;
import com.ahsay.ani.util.nix.NixUtil;

public class AixUtil
extends NixUtil {
    private native String getVersionN();

    private native String getSystemModelN();

    private native String getCpuModelN();

    private native String getHardDiskSerialNumberN(ComputerInfo var1);

    private native String getMotherboardUUIDN();

    public AixUtil(boolean bl) {
        super(bl);
    }

    @Override
    public String getOSVersion() {
        String string = AixUtil.a("uname -s");
        String string2 = AixUtil.a("uname -v");
        String string3 = AixUtil.a("uname -r");
        return string + " " + string2 + "." + string3;
    }

    @Override
    public String getSystemModel() {
        String string = "System Model";
        String string2 = AixUtil.a("prtconf | grep \\\"" + string + "\\\"", string + ": ").trim();
        return string2;
    }

    @Override
    public String getCpuModel() {
        int n;
        String string = "Number Of Processors";
        String string2 = AixUtil.a("prtconf | grep \\\"" + string + "\\\"", string + ":").trim();
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = 1;
        }
        String string3 = "Processor Type";
        String string4 = AixUtil.a("prtconf | grep \\\"" + string3 + "\\\"", string3 + ":").trim();
        Object object = string4;
        for (int i = 1; i < n; ++i) {
            object = (String)object + "," + string4;
        }
        return object;
    }

    @Override
    public void getHardDiskSN(ComputerInfo computerInfo) {
        block5: {
            try {
                LineCommand$Output lineCommand$Output = LineCommand.execute("lspv", null, null);
                if (lineCommand$Output.getExitCode() == 0) {
                    for (String string : lineCommand$Output.getOutputMessages()) {
                        String string2;
                        String string3;
                        boolean bl = false;
                        String string4 = string.trim();
                        String[] stringArray = StringUtil.split(string4, " ");
                        String string5 = stringArray[0];
                        if (string5 == null) continue;
                        String string6 = AixUtil.a("lscfg -vl " + string5 + " | grep \\\"Serial Number\\\"", "Serial Number...............");
                        if (stringArray.length >= 2 && !"".equals(string3 = AixUtil.a("lsvg -l " + (string2 = stringArray[2]) + " | grep \\\" boot \\\"", null))) {
                            bl = true;
                        }
                        computerInfo.addDiskInfo(string5, string6, bl);
                    }
                }
            }
            catch (Throwable throwable) {
                if (!NIX_DEBUG) break block5;
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public String getMotherboardUUID() {
        String string = "Machine Serial Number";
        String string2 = AixUtil.a("prtconf | grep \\\"" + string + "\\\"", string + ":").trim();
        return string2;
    }

    private static String a(String string) {
        return AixUtil.a(string, null);
    }

    private static String a(String string, String string2) {
        block5: {
            try {
                LineCommand$Output lineCommand$Output = LineCommand.execute(string, null, null);
                if (lineCommand$Output.getExitCode() == 0) {
                    if (string2 == null) {
                        return lineCommand$Output.getOutputMessage();
                    }
                    for (String string3 : lineCommand$Output.getOutputMessages()) {
                        String string4 = string3.trim();
                        if (!string4.startsWith(string2)) continue;
                        return StringUtil.lTrim(string4, string2);
                    }
                }
            }
            catch (Throwable throwable) {
                if (!NIX_DEBUG) break block5;
                throwable.printStackTrace();
            }
        }
        return "";
    }
}

