/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.ani.util;

import com.ahsay.ani.SystemInfo;
import com.ahsay.ani.util.MacFileList$MacFile;
import com.ahsay.ani.util.MacUtil;
import com.ahsay.ani.util.NormalFile;
import com.ahsay.ani.util.StringUtil;
import com.ahsay.ani.util.WinFileList$WinFile;
import com.ahsay.ani.util.WindowsUtil;
import com.ahsay.ani.util.nix.NixFileList$NixFile;
import com.ahsay.ani.util.nix.NixUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;

public class FileUtil {
    public static final boolean DEBUG;
    protected static final boolean SKIP_WINUTIL;
    public static final boolean ENFORCE_NATIVE_DEBUG;
    private static NixUtil a;
    private static WindowsUtil b;
    private static MacUtil c;

    public static boolean isNetworkDrive(String string) {
        String string2;
        String string3;
        if (SystemInfo.IS_MAC) {
            string3 = "/Volumes/";
            if ("/".equals(string) || "/Volumes/".equals(string)) {
                return true;
            }
            string2 = StringUtil.rTrim(string, "/");
            if (string2.startsWith("/Volumes/") && string2.length() > "/Volumes/".length() && string2.indexOf("/", "/Volumes/".length() + 1) == -1 && new File(string).isDirectory()) {
                return true;
            }
        }
        if (SystemInfo.IS_WINDOWS) {
            string3 = "\\\\";
            string2 = "\\\\?\\";
            if (string.startsWith("\\\\") && !string.startsWith("\\\\?\\")) {
                String string4 = StringUtil.lTrim(string, "\\\\");
                int n = (string4 = StringUtil.rTrim(string4, "\\")).indexOf("\\");
                if (n == -1) {
                    return true;
                }
                return string4.indexOf("\\", n + 1) == -1;
            }
        } else if (SystemInfo.IS_NETWARE || SystemInfo.IS_LINUX_RELATED) {
            // empty if block
        }
        return false;
    }

    public static boolean exists(File file) {
        if (file == null) {
            return false;
        }
        if (b != null) {
            String string;
            if (SystemInfo.IS_WIN_NT_2K_XP && !(string = file.getAbsolutePath()).endsWith("\\")) {
                return b.exists(string);
            }
        } else {
            if (a != null) {
                return a.isFileExist(file.getAbsolutePath());
            }
            if (c != null) {
                return c.doesExistAtPath(file.getAbsolutePath());
            }
        }
        return file.exists();
    }

    public static boolean isFile(File file) {
        if (!FileUtil.exists(file)) {
            return false;
        }
        return !FileUtil.a(file);
    }

    public static boolean isDirectory(File file) {
        if (!FileUtil.exists(file)) {
            return false;
        }
        return FileUtil.a(file);
    }

    private static boolean a(File file) {
        if (!SystemInfo.IS_WIN_NT_2K_XP) {
            return file.isDirectory();
        }
        String string = file.getAbsolutePath();
        if (!string.endsWith(":\\")) {
            String[] stringArray;
            if (string.startsWith("\\\\") && (stringArray = StringUtil.split(string, File.separator)).length <= 4) {
                return true;
            }
            if (b != null) {
                return b.isDir(string);
            }
        }
        return file.isDirectory();
    }

    public static String[] split(String string, String string2) {
        Vector<String> vector = new Vector<String>(16, 16);
        int n = 0;
        int n2 = 0;
        if (string == null || string2 == null || string2.equals("")) {
            String[] stringArray = new String[]{string};
            return stringArray;
        }
        while ((n2 = string.indexOf(string2, n)) != -1) {
            vector.addElement(string.substring(n, n2));
            n = n2 + string2.length();
        }
        vector.addElement(string.substring(n));
        return vector.toArray(new String[vector.size()]);
    }

    public static byte getTargetPathType(File file) {
        block14: {
            if (b != null && file instanceof WinFileList$WinFile) {
                return ((WinFileList$WinFile)file).getFinalTargetType();
            }
            if (a != null) {
                if (file instanceof NixFileList$NixFile) {
                    String string = a.getLinkAbsolutePath((NixFileList$NixFile)file);
                    string = FileUtil.resolveDotsAndTailingSlashFromPath(string);
                    try {
                        if (a.isFileExist(string)) {
                            if (a.getIsPathLink(string)) {
                                return a.getFinalTargetType(string);
                            }
                            if (a.getIsPathDir(string)) {
                                return 0;
                            }
                            if (a.getIsPathFile(string)) {
                                return 2;
                            }
                            if (a.getIsPathNamedPipe(string)) {
                                return 34;
                            }
                            break block14;
                        }
                        return 1;
                    }
                    catch (IOException iOException) {
                        return 1;
                    }
                }
            } else if (c != null) {
                if (file instanceof MacFileList$MacFile) {
                    MacFileList$MacFile macFileList$MacFile = (MacFileList$MacFile)file;
                    return c.getTypeAtTargetPath_ofSymlinkFilePath_(macFileList$MacFile.getCanonicalPath(), macFileList$MacFile.getPath());
                }
            } else {
                return ((NormalFile)file).getTargetPathType();
            }
        }
        return 1;
    }

    public static String resolveDotsAndTailingSlashFromPath(String string) {
        String string2;
        char[] cArray = string.toCharArray();
        int n = -1;
        ArrayList<Object> arrayList = new ArrayList<Object>(100);
        StringBuffer stringBuffer = new StringBuffer(50);
        while (n < cArray.length - 1) {
            char c;
            if ((c = cArray[++n]) == File.separatorChar) {
                String string3 = stringBuffer.toString();
                stringBuffer.setLength(0);
                if (string3.equals("..")) {
                    if (arrayList.size() <= 1) continue;
                    arrayList.remove(arrayList.size() - 1);
                    continue;
                }
                if (string3.equals(".")) continue;
                if (string3.equals("")) {
                    if (arrayList.size() == 1 && c == '\\') {
                        string2 = (String)arrayList.get(0);
                        if (string2.equals("\\")) {
                            arrayList.set(0, "\\\\");
                            continue;
                        }
                        if (arrayList.size() != 0) continue;
                        arrayList.add(string3 + c);
                        continue;
                    }
                    if (arrayList.size() != 0) continue;
                    arrayList.add(string3 + c);
                    continue;
                }
                if (arrayList.size() == 1) {
                    string2 = (String)arrayList.get(0);
                    if (string2.equals("\\\\")) {
                        arrayList.set(0, "\\\\" + string3 + c);
                        continue;
                    }
                    arrayList.add(string3 + c);
                    continue;
                }
                arrayList.add(string3 + c);
                continue;
            }
            stringBuffer.append(c);
        }
        if (stringBuffer.length() > 0) {
            String string4 = stringBuffer.toString();
            stringBuffer.setLength(0);
            if (string4.equals("..")) {
                if (arrayList.size() > 2) {
                    arrayList.remove(arrayList.size() - 1);
                }
            } else if (!string4.equals(".")) {
                arrayList.add(string4);
            }
        }
        int n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            string2 = (String)arrayList.get(i);
            char[] cArray2 = string2.toCharArray();
            System.arraycopy(cArray2, 0, cArray, n2, cArray2.length);
            n2 += cArray2.length;
        }
        if (cArray[n2 - 1] == File.separatorChar) {
            --n2;
        }
        if (n2 >= 2 && cArray[1] == ':' && Character.isLetter(cArray[0])) {
            cArray[0] = Character.toUpperCase(cArray[0]);
        }
        String string5 = new String(cArray, 0, n2);
        return string5;
    }

    public static boolean isLink(File file) {
        try {
            if (b != null) {
                return b.isLink(file.getAbsolutePath());
            }
            if (a != null) {
                try {
                    return a.isLink(file.getAbsolutePath());
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
            }
            String string = file.getAbsolutePath();
            String string2 = file.getCanonicalPath();
            if (SystemInfo.IS_NETWARE) {
                boolean bl;
                boolean bl2 = bl = !string.equalsIgnoreCase(string2);
                return bl && !string2.equalsIgnoreCase(string + "\\") && !string.equalsIgnoreCase(string2 + "\\");
            }
            return !string.equals(string2);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String getTargetPath(String string) {
        if (b != null) {
            return b.getLinkTarget(string);
        }
        if (a != null) {
            return a.getTargetPath(string);
        }
        if (c != null) {
            // empty if block
        }
        return null;
    }

    public static String getCanonicalPath(String string) {
        return new File(string).getCanonicalPath();
    }

    public static boolean isSupportExtendFileSize(String string) {
        if (b != null) {
            return b.isSupportExtendFileSize(string);
        }
        return true;
    }

    public static String getParent(String string) {
        int n = 92;
        int n2 = 47;
        String string2 = "\\\\";
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.length() > 2 && string.charAt(1) == ':' && string.charAt(2) == '\\') {
            String string3 = ":\\";
            if (string.length() == 3) {
                return null;
            }
            int n3 = string.lastIndexOf(92);
            if (n3 == -1) {
                return null;
            }
            String string4 = string.substring(0, n3);
            if (string4.length() == 2) {
                return string4 + "\\";
            }
            return string4;
        }
        if (string.length() == 2 && string.charAt(1) == ':') {
            return null;
        }
        if (string.charAt(0) == '\\' && string.charAt(1) == '\\') {
            if (string.length() == 2) {
                return null;
            }
            int n4 = string.lastIndexOf(92);
            if (n4 == 1) {
                return "\\\\";
            }
            return string.substring(0, n4);
        }
        if (string.charAt(0) == '/') {
            if (string.length() == 1) {
                return null;
            }
            int n5 = string.lastIndexOf(47);
            if (n5 == 0) {
                return "/";
            }
            return string.substring(0, n5);
        }
        int n6 = string.lastIndexOf(92);
        if (n6 != -1) {
            String string5 = string.substring(0, n6);
            return string5;
        }
        n6 = string.lastIndexOf(47);
        if (n6 != -1) {
            String string6 = string.substring(0, n6);
            return string6;
        }
        return null;
    }

    static {
        block11: {
            DEBUG = "true".equalsIgnoreCase(System.getProperty("com.ahsay.afc.util.FileUtil.debug"));
            SKIP_WINUTIL = "true".equalsIgnoreCase(System.getProperty("com.ahsay.afc.util.FileUtil.skipWinUtil"));
            ENFORCE_NATIVE_DEBUG = "true".equalsIgnoreCase(System.getProperty("com.ahsay.ani.util.FileUtil.EnforceNative.debug"));
            a = null;
            b = null;
            c = null;
            if (WindowsUtil.IS_SUPPORTED && !SKIP_WINUTIL) {
                try {
                    b = new WindowsUtil();
                }
                catch (Throwable throwable) {
                    if (DEBUG) {
                        System.out.println("[info][FileUtil.init] Unable to load WindowsUtil.dll");
                        throwable.printStackTrace();
                    }
                    break block11;
                }
            }
            if (SystemInfo.IS_LINUX_RELATED || SystemInfo.IS_OPENBSD) {
                try {
                    a = NixUtil.getInstance();
                }
                catch (Throwable throwable) {
                    if (DEBUG) {
                        System.out.println("[info][FileUtil.init] NixUtil.getInstance() failed");
                        throwable.printStackTrace();
                    }
                    break block11;
                }
            }
            if (MacUtil.IS_SUPPORTED) {
                try {
                    c = new MacUtil();
                }
                catch (Throwable throwable) {
                    if (!DEBUG) break block11;
                    System.out.println("[info][FileUtil.init] Unable to load MacUtil");
                    throwable.printStackTrace();
                }
            }
        }
    }
}

