/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.ani.io;

import com.ahsay.ani.SystemInfo;
import com.ahsay.ani.io.BufferPool$SavedBuffer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BufferPool {
    public static final BufferPool SINGLETON = new BufferPool();
    public static final long DEFAULT_IDLE_TIMEOUT = 60000L;
    private static final boolean a = "true".equalsIgnoreCase(System.getProperty("com.ahsay.ani.io.BufferPool.SuppressDuplicateChecking"));
    private final long b;
    private final ConcurrentLinkedQueue<BufferPool$SavedBuffer<ByteBuffer>> c = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<BufferPool$SavedBuffer<byte[]>> d = new ConcurrentLinkedQueue();
    private final ReadWriteLock e = new ReentrantReadWriteLock();
    private final ReadWriteLock f = new ReentrantReadWriteLock();
    private volatile long g = 0L;
    private volatile long h = 0L;

    public BufferPool() {
        this(60000L);
    }

    public BufferPool(long l) {
        this.b = l;
    }

    public ByteBuffer allocByteBuffer(int n) {
        ByteBuffer byteBuffer;
        try {
            if (SystemInfo.IS_JVM_16) {
                throw new NoSuchElementException();
            }
            BufferPool$SavedBuffer bufferPool$SavedBuffer = this.a(this.c, this.e, n);
            byteBuffer = (ByteBuffer)bufferPool$SavedBuffer.a();
        }
        catch (NoSuchElementException noSuchElementException) {
            byteBuffer = ByteBuffer.allocateDirect(n);
        }
        return byteBuffer;
    }

    public byte[] allocByteArray(int n) {
        byte[] byArray;
        try {
            if (SystemInfo.IS_JVM_16) {
                throw new NoSuchElementException();
            }
            BufferPool$SavedBuffer bufferPool$SavedBuffer = this.a(this.d, this.f, n);
            byArray = (byte[])bufferPool$SavedBuffer.a();
        }
        catch (NoSuchElementException noSuchElementException) {
            byArray = new byte[n];
        }
        return byArray;
    }

    public void recycle(byte[] byArray) {
        this.recycle(byArray, true);
    }

    public void recycle(byte[] byArray, boolean bl) {
        if (byArray == null) {
            return;
        }
        this.a(byArray, byArray.length, this.d, this.f, bl);
    }

    public void recycle(ByteBuffer byteBuffer) {
        this.recycle(byteBuffer, true);
    }

    public void recycle(ByteBuffer byteBuffer, boolean bl) {
        if (byteBuffer == null || !byteBuffer.isDirect()) {
            return;
        }
        this.a(byteBuffer, byteBuffer.capacity(), this.c, this.e, bl);
    }

    private <T> void a(T t, int n, ConcurrentLinkedQueue<BufferPool$SavedBuffer<T>> concurrentLinkedQueue, ReadWriteLock readWriteLock, boolean bl) {
        if (bl) {
            if (SystemInfo.IS_JVM_16) {
                return;
            }
            BufferPool$SavedBuffer<T> bufferPool$SavedBuffer = this.a(concurrentLinkedQueue, readWriteLock, n);
            bufferPool$SavedBuffer.a(t);
            return;
        }
        if (t instanceof ByteBuffer) {
            try {
                Method method = t.getClass().getMethod("cleaner", new Class[0]);
                method.setAccessible(true);
                Object object = method.invoke(t, new Object[0]);
                Method method2 = object.getClass().getMethod("clean", new Class[0]);
                method2.setAccessible(true);
                method2.invoke(object, new Object[0]);
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> BufferPool$SavedBuffer<T> a(ConcurrentLinkedQueue<BufferPool$SavedBuffer<T>> concurrentLinkedQueue, ReadWriteLock readWriteLock, int n) {
        Object object2;
        block19: {
            long l = System.currentTimeMillis();
            if (l > (readWriteLock == this.e ? this.g : this.h) + this.b) {
                readWriteLock.writeLock().lock();
                try {
                    l = System.currentTimeMillis();
                    if (l <= (readWriteLock == this.e ? this.g : this.h) + this.b) break block19;
                    try {
                        object2 = concurrentLinkedQueue.iterator();
                        while (object2.hasNext()) {
                            BufferPool$SavedBuffer<T> object3 = object2.next();
                            object3.a(this, l);
                            if (!object3.b()) continue;
                            object2.remove();
                        }
                    }
                    finally {
                        if (readWriteLock == this.e) {
                            this.g = l;
                        } else {
                            this.h = l;
                        }
                    }
                }
                finally {
                    readWriteLock.writeLock().unlock();
                }
            }
        }
        readWriteLock.readLock().lock();
        try {
            for (BufferPool$SavedBuffer<T> bufferPool$SavedBuffer : concurrentLinkedQueue) {
                if (bufferPool$SavedBuffer.b != n) continue;
                BufferPool$SavedBuffer<T> bufferPool$SavedBuffer2 = bufferPool$SavedBuffer;
                return bufferPool$SavedBuffer2;
            }
        }
        finally {
            readWriteLock.readLock().unlock();
        }
        readWriteLock.writeLock().lock();
        try {
            for (BufferPool$SavedBuffer<T> bufferPool$SavedBuffer : concurrentLinkedQueue) {
                if (bufferPool$SavedBuffer.b != n) continue;
                BufferPool$SavedBuffer<T> bufferPool$SavedBuffer3 = bufferPool$SavedBuffer;
                return bufferPool$SavedBuffer3;
            }
            object2 = new BufferPool$SavedBuffer(n);
            concurrentLinkedQueue.add((BufferPool$SavedBuffer<T>)object2);
            Object object = object2;
            return object;
        }
        finally {
            readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.f.writeLock().lock();
        try {
            for (BufferPool$SavedBuffer<byte[]> bufferPool$SavedBuffer : this.d) {
                bufferPool$SavedBuffer.a(this);
            }
            this.d.clear();
        }
        finally {
            this.f.writeLock().unlock();
        }
        this.e.writeLock().lock();
        try {
            for (BufferPool$SavedBuffer<Object> bufferPool$SavedBuffer : this.c) {
                bufferPool$SavedBuffer.a(this);
            }
            this.c.clear();
        }
        finally {
            this.e.writeLock().unlock();
        }
    }
}

