/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.ani.fsutil;

import com.ahsay.ani.NoObfuscation;
import com.ahsay.ani.db.tmp.Column;
import com.ahsay.ani.fsutil.FileSystemObjectType;
import com.ahsay.ani.fsutil.Platform;
import com.ahsay.ani.util.Objects;
import java.io.File;

@NoObfuscation
public class ChildFile
implements Comparable<ChildFile> {
    public static final int FILE_ATTRIBUTE_READONLY = 1;
    public static final int FILE_ATTRIBUTE_HIDDEN = 2;
    public static final int FILE_ATTRIBUTE_SYSTEM = 4;
    public static final int FILE_ATTRIBUTE_DIRECTORY = 16;
    public static final int FILE_ATTRIBUTE_ARCHIVE = 32;
    public static final int FILE_ATTRIBUTE_DEVICE = 64;
    public static final int FILE_ATTRIBUTE_NORMAL = 128;
    public static final int FILE_ATTRIBUTE_TEMPORARY = 256;
    public static final int FILE_ATTRIBUTE_SPARSE_FILE = 512;
    public static final int FILE_ATTRIBUTE_REPARSE_POINT = 1024;
    public static final int FILE_ATTRIBUTE_COMPRESSED = 2048;
    public static final int FILE_ATTRIBUTE_OFFLINE = 4096;
    public static final int FILE_ATTRIBUTE_NOT_CONTENT_INDEXED = 8192;
    public static final int FILE_ATTRIBUTE_ENCRYPTED = 16384;
    public static final int FILE_ATTRIBUTE_VIRTUAL = 65536;
    public static final int FILE_ATTRIBUTE_RECALL_ON_OPEN = 262144;
    public static final int FILE_ATTRIBUTE_RECALL_ON_DATA_ACCESS = 0x400000;
    public static final int IO_REPARSE_TAG_MOUNT_POINT = -1610612733;
    public static final int IO_REPARSE_TAG_SYMLINK = -1610612724;
    private static final int a = Integer.parseInt("0170000", 8);
    private static final int b = Integer.parseInt("0120000", 8);
    private static final int c = Integer.parseInt("0040000", 8);
    private static final int d = Integer.parseInt("0100000", 8);
    private static final int e = Integer.parseInt("0140000", 8);
    private static final int f = Integer.parseInt("0010000", 8);
    private static final int g = Integer.parseInt("0060000", 8);
    private static final int h = Integer.parseInt("0020000", 8);
    @Column
    protected int fileIndex;
    @Column
    protected long creationTime;
    @Column
    protected long lastAccessTime;
    @Column
    protected long changeTime;
    @Column
    protected long allocationSize;
    @Column
    protected int fileAttributes;
    @Column
    protected String parent;
    @Column
    protected String name;
    @Column
    protected FileSystemObjectType fsoType;
    @Column
    protected long lastModified;
    @Column
    protected long size;
    @Column
    protected long dev;
    @Column
    protected long ino;
    @Column
    protected int nlink;
    @Column
    protected int uid;
    @Column
    protected int gid;
    @Column
    protected long rdev;
    @Column
    protected long blksize;
    @Column
    protected long blocks;
    @Column
    protected Platform platform = Platform.CLOUD;
    protected long lCreationTimeJava = -1L;
    protected long lLastAccessTimeJava = -1L;
    protected long lLastModifiedJava = -1L;
    protected long lChangeTimeJava = -1L;
    protected boolean bLinkWin = false;

    public ChildFile() {
    }

    public ChildFile(String string) {
        this.parent = string;
    }

    public ChildFile(String string, String string2, FileSystemObjectType fileSystemObjectType, long l, long l2) {
        this.parent = string;
        this.setBasic(string2, fileSystemObjectType, l, l2);
    }

    public ChildFile(ChildFile childFile) {
        this.parent = childFile.parent;
        this.setBasic(childFile.name, childFile.fsoType, childFile.lastModified, childFile.size);
        this.setBasic(childFile.name, childFile.fileIndex, childFile.creationTime, childFile.lastAccessTime, childFile.lastModified, childFile.changeTime, childFile.size, childFile.allocationSize, childFile.fileAttributes);
        this.setBasic(childFile.name, childFile.dev, childFile.ino, childFile.fileAttributes, childFile.nlink, childFile.uid, childFile.gid, childFile.rdev, childFile.size, childFile.blksize, childFile.blocks, childFile.lastAccessTime, childFile.lastModified, childFile.changeTime);
    }

    @NoObfuscation
    public void setBasic(String string, FileSystemObjectType fileSystemObjectType, long l, long l2) {
        this.name = string;
        this.fsoType = fileSystemObjectType;
        this.lastModified = l;
        this.size = l2;
    }

    @NoObfuscation
    public void setBasic(String string, int n, long l, long l2, long l3, long l4, long l5, long l6, int n2) {
        this.name = string;
        this.fileIndex = n;
        this.creationTime = l;
        this.lastAccessTime = l2;
        this.lastModified = l3;
        this.changeTime = l4;
        this.size = l5;
        this.allocationSize = l6;
        this.fileAttributes = n2;
        this.fsoType = this.isDirectory() ? FileSystemObjectType.DIRECTORY : FileSystemObjectType.FILE;
    }

    @NoObfuscation
    public void setBasic(String string, long l, long l2, int n, int n2, int n3, int n4, long l3, long l4, long l5, long l6, long l7, long l8, long l9) {
        this.name = string;
        this.dev = l;
        this.ino = l2;
        this.fileAttributes = n;
        this.nlink = n2;
        this.uid = n3;
        this.gid = n4;
        this.rdev = l3;
        this.size = l4;
        this.blksize = l5;
        this.blocks = l6;
        this.lastAccessTime = l7;
        this.lastModified = l8;
        this.changeTime = l9;
        this.fsoType = this.isDirectory() ? FileSystemObjectType.DIRECTORY : FileSystemObjectType.FILE;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String string) {
        this.parent = string;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public long getLastModifiedNative() {
        return this.lastModified;
    }

    public long getLastModified() {
        if (this.lLastModifiedJava >= 0L) {
            return this.lLastModifiedJava;
        }
        this.lLastModifiedJava = this.platform == Platform.WIN ? this.lastModified / 10000L - 11644473600000L : (this.platform == Platform.NIX ? this.lastModified * 1000L : (this.platform == Platform.MAC ? this.lastModified * 1000L : this.lastModified));
        return this.lLastModifiedJava;
    }

    public void setLastModified(long l) {
        this.lLastModifiedJava = l;
    }

    public long getLastAccessTimeNative() {
        return this.lastAccessTime;
    }

    public long getLastAccessTime() {
        if (this.lLastAccessTimeJava >= 0L) {
            return this.lLastAccessTimeJava;
        }
        this.lLastAccessTimeJava = this.platform == Platform.WIN ? this.lastAccessTime / 10000L - 11644473600000L : (this.platform == Platform.NIX ? this.lastAccessTime * 1000L : (this.platform == Platform.MAC ? this.lastAccessTime * 1000L : this.lastAccessTime));
        return this.lLastAccessTimeJava;
    }

    public void setLastAccessTime(long l) {
        this.lLastAccessTimeJava = l;
    }

    public long getChangeTimeNative() {
        return this.changeTime;
    }

    public long getChangeTime() {
        if (this.lChangeTimeJava >= 0L) {
            return this.lChangeTimeJava;
        }
        this.lChangeTimeJava = this.platform == Platform.WIN ? this.changeTime / 10000L - 11644473600000L : (this.platform == Platform.NIX ? this.changeTime * 1000L : (this.platform == Platform.MAC ? this.changeTime * 1000L : this.changeTime));
        return this.lChangeTimeJava;
    }

    public void setChangeTime(long l) {
        this.lChangeTimeJava = l;
    }

    public long getCreationTimeNative() {
        return this.creationTime;
    }

    public long getCreationTime() {
        if (Platform.WIN != this.platform) {
            throw new RuntimeException("[ChildFile.getCreationTime] value not available");
        }
        if (this.lCreationTimeJava >= 0L) {
            return this.lCreationTimeJava;
        }
        this.lCreationTimeJava = this.platform == Platform.WIN ? this.creationTime / 10000L - 11644473600000L : (this.platform == Platform.NIX ? this.creationTime : (this.platform == Platform.MAC ? this.creationTime : this.creationTime));
        return this.lCreationTimeJava;
    }

    public void setCreationTime(long l) {
        this.lCreationTimeJava = l;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long l) {
        this.size = l;
    }

    public FileSystemObjectType getFileSystemObjectType() {
        return this.fsoType;
    }

    public void setFileSystemObjectType(FileSystemObjectType fileSystemObjectType) {
        this.fsoType = fileSystemObjectType;
    }

    public boolean isDirectory() {
        if (this.fsoType == null || FileSystemObjectType.UNKNOWN == this.fsoType) {
            boolean bl = false;
            if (this.platform == Platform.WIN) {
                bl = (this.fileAttributes & 0x10) == 16;
            } else if (this.platform == Platform.NIX) {
                bl = (this.fileAttributes & a) == c;
            } else if (this.platform == Platform.MAC) {
                bl = (this.fileAttributes & a) == c;
            }
            this.fsoType = bl ? FileSystemObjectType.DIRECTORY : FileSystemObjectType.FILE;
        }
        return FileSystemObjectType.DIRECTORY == this.fsoType;
    }

    public boolean isFile() {
        if (this.fsoType == null || FileSystemObjectType.UNKNOWN == this.fsoType) {
            this.fsoType = this.isDirectory() ? FileSystemObjectType.DIRECTORY : FileSystemObjectType.FILE;
        }
        return FileSystemObjectType.FILE == this.fsoType;
    }

    public boolean isLink() {
        if (this.platform == Platform.WIN) {
            return this.bLinkWin;
        }
        if (this.platform == Platform.NIX) {
            return (this.fileAttributes & a) == e || (this.fileAttributes & a) == b;
        }
        if (this.platform == Platform.MAC) {
            return (this.fileAttributes & a) == e || (this.fileAttributes & a) == b;
        }
        return false;
    }

    public boolean isHidden() {
        return this.platform == Platform.WIN && (this.fileAttributes & 2) != 0;
    }

    public void setLinkWin(boolean bl) {
        this.bLinkWin = bl;
    }

    public boolean isEfs() {
        if (this.platform != Platform.WIN) {
            return false;
        }
        return (this.fileAttributes & 0x4000) != 0;
    }

    public boolean isOffline() {
        if (this.platform != Platform.WIN) {
            return false;
        }
        return (this.fileAttributes & 0x1000) != 0;
    }

    public boolean isCompressed() {
        if (this.platform != Platform.WIN) {
            return false;
        }
        return (this.fileAttributes & 0x800) != 0;
    }

    public boolean isVirtual() {
        if (this.platform != Platform.WIN) {
            return false;
        }
        return (this.fileAttributes & 0x10000) != 0;
    }

    public boolean isContentIndexed() {
        if (this.platform != Platform.WIN) {
            return false;
        }
        return (this.fileAttributes & 0x2000) == 0;
    }

    public boolean isTemporary() {
        if (this.platform != Platform.WIN) {
            return false;
        }
        return (this.fileAttributes & 0x100) != 0;
    }

    public boolean isSparse() {
        if (this.platform != Platform.WIN) {
            return false;
        }
        return (this.fileAttributes & 0x200) != 0;
    }

    public boolean isBackupable() {
        if (this.name.contains("\ufffd") || this.name.contains("\ufffe") || this.name.contains("\uffff")) {
            return false;
        }
        if (this.platform == Platform.CLOUD || this.platform == Platform.JAVA) {
            return true;
        }
        if (this.platform == Platform.WIN) {
            return (this.fileAttributes & 0x441000) == 0;
        }
        return !this.isBlockDev() && !this.isCharDev() && !this.isNamedPipe() && !this.isSocket();
    }

    public String getPath() {
        return new File(this.parent, this.name).getPath();
    }

    @Override
    public int compareTo(ChildFile childFile) {
        if (this == childFile) {
            return 0;
        }
        int n = this.compare(this.parent, childFile.parent);
        if (n != 0) {
            return n;
        }
        n = this.compare(this.fsoType, childFile.fsoType);
        if (n != 0) {
            return n;
        }
        n = this.compare(this.name, childFile.name);
        if (n != 0) {
            return n;
        }
        return 0;
    }

    protected final <T extends Comparable<T>> int compare(T t, T t2) {
        if (t == null) {
            if (t2 != null) {
                return -1;
            }
        } else {
            if (t2 == null) {
                return 1;
            }
            int n = t.compareTo(t2);
            if (n != 0) {
                return n;
            }
        }
        return 0;
    }

    public int getGid() {
        if (Platform.JAVA == this.platform || Platform.WIN == this.platform) {
            throw new RuntimeException("[ChildFile.getGid] value not available");
        }
        return this.gid;
    }

    public int getUid() {
        if (Platform.JAVA == this.platform || Platform.WIN == this.platform) {
            throw new RuntimeException("[ChildFile.getUid] value not available");
        }
        return this.uid;
    }

    public int getMode() {
        if (Platform.JAVA == this.platform || Platform.WIN == this.platform) {
            throw new RuntimeException("[ChildFile.getMode] value not available");
        }
        return this.fileAttributes;
    }

    public long getInode() {
        if (Platform.JAVA == this.platform || Platform.WIN == this.platform) {
            throw new RuntimeException("[ChildFile.getInode] value not available");
        }
        return this.ino;
    }

    public long getNLink() {
        if (Platform.JAVA == this.platform || Platform.WIN == this.platform) {
            throw new RuntimeException("[ChildFile.getNLink] value not available");
        }
        return this.nlink;
    }

    public long getRDev() {
        if (Platform.JAVA == this.platform || Platform.WIN == this.platform) {
            throw new RuntimeException("[ChildFile.getRDev] value not available");
        }
        return this.rdev;
    }

    public boolean isNamedPipe() {
        if (Platform.JAVA == this.platform || Platform.WIN == this.platform) {
            throw new RuntimeException("[ChildFile.isNamedPipe] value not available");
        }
        return (this.fileAttributes & a) == f;
    }

    public boolean isSocket() {
        if (Platform.JAVA == this.platform || Platform.WIN == this.platform) {
            throw new RuntimeException("[ChildFile.isSocket] value not available");
        }
        return (this.fileAttributes & a) == e;
    }

    public boolean isBlockDev() {
        if (Platform.JAVA == this.platform || Platform.WIN == this.platform) {
            throw new RuntimeException("[ChildFile.isBlockDev] value not available");
        }
        return (this.fileAttributes & a) == g;
    }

    public boolean isCharDev() {
        if (Platform.JAVA == this.platform || Platform.WIN == this.platform) {
            throw new RuntimeException("[ChildFile.isCharDev] value not available");
        }
        return (this.fileAttributes & a) == h;
    }

    public long getBlockSize() {
        if (Platform.JAVA == this.platform || Platform.WIN == this.platform) {
            throw new RuntimeException("[ChildFile.getBlockSize] value not available");
        }
        return this.blksize;
    }

    public long getBlocks() {
        if (Platform.JAVA == this.platform || Platform.WIN == this.platform) {
            throw new RuntimeException("[ChildFile.getBlocks] value not available");
        }
        return this.blocks;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ChildFile)) {
            return false;
        }
        ChildFile childFile = (ChildFile)object;
        return this.fileIndex == childFile.fileIndex && this.creationTime == childFile.creationTime && this.lastAccessTime == childFile.lastAccessTime && this.changeTime == childFile.changeTime && this.allocationSize == childFile.allocationSize && this.fileAttributes == childFile.fileAttributes && Objects.equals(this.parent, childFile.parent) && Objects.equals(this.name, childFile.name) && Objects.equals(this.fsoType, childFile.fsoType) && this.lastModified == childFile.lastModified && this.size == childFile.size && this.dev == childFile.dev && this.ino == childFile.ino && this.nlink == childFile.nlink && this.uid == childFile.uid && this.gid == childFile.gid && this.rdev == childFile.rdev && this.blksize == childFile.blksize && this.blocks == childFile.blocks && this.platform == childFile.platform && this.lCreationTimeJava == childFile.lCreationTimeJava && this.lLastAccessTimeJava == childFile.lLastAccessTimeJava && this.lLastModifiedJava == childFile.lLastModifiedJava && this.lChangeTimeJava == childFile.lChangeTimeJava;
    }

    public String toString() {
        return "ChildFile{fileAttributes=" + this.fileAttributes + ", name='" + this.name + "', fsoType=" + String.valueOf(this.fsoType) + ", lastModified=" + this.lastModified + ", size=" + this.size + "}";
    }
}

