/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.ani.event;

import com.ahsay.ani.event.AbstractEvent$DebugLock;
import com.ahsay.ani.event.EventModel;
import com.ahsay.ani.util.DateUtil;
import java.text.MessageFormat;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractEvent
implements EventModel {
    public static final String DEBUG_PROP = "com.ahsay.afc.event.AbstractEvent.debug";
    public static final boolean DEBUG = "true".equalsIgnoreCase(System.getProperty("com.ahsay.afc.event.AbstractEvent.debug"));
    protected final List<EventListener> llListeners = new LinkedList<EventListener>();
    protected final ReentrantReadWriteLock REENTRANT_LOCK = new ReentrantReadWriteLock();
    protected final Lock R_LOCK = DEBUG ? new AbstractEvent$DebugLock(this.REENTRANT_LOCK.readLock(), "Read", this.REENTRANT_LOCK.writeLock().hashCode()) : this.REENTRANT_LOCK.readLock();
    protected final Lock W_LOCK;

    public AbstractEvent() {
        Lock lock = this.W_LOCK = DEBUG ? new AbstractEvent$DebugLock(this.REENTRANT_LOCK.writeLock(), "Write", this.REENTRANT_LOCK.readLock().hashCode()) : this.REENTRANT_LOCK.writeLock();
        if (this.R_LOCK instanceof AbstractEvent$DebugLock) {
            ((AbstractEvent$DebugLock)this.R_LOCK).setOtherLock(this.W_LOCK);
        }
        if (this.W_LOCK instanceof AbstractEvent$DebugLock) {
            ((AbstractEvent$DebugLock)this.W_LOCK).setOtherLock(this.R_LOCK);
        }
    }

    public final List<EventListener> getListeners() {
        return this.llListeners;
    }

    public Lock getReadLock() {
        return this.R_LOCK;
    }

    public Lock getWriteLock() {
        return this.W_LOCK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(EventListener eventListener) {
        if (eventListener == null) {
            return;
        }
        this.W_LOCK.lock();
        try {
            if (DEBUG) {
                String string = "{0} [AbstractEvent.addListener] TotalListeners=''{3}'' Thread=''{1}'' EventListener=''{2}(@{4})''";
                String[] stringArray = new String[]{DateUtil.getLogTime(), Thread.currentThread().getName(), eventListener.toString(), Integer.toString(this.llListeners.size()), Integer.toString(eventListener.hashCode())};
                String string2 = MessageFormat.format("{0} [AbstractEvent.addListener] TotalListeners=''{3}'' Thread=''{1}'' EventListener=''{2}(@{4})''", stringArray);
                System.out.println(string2);
            }
            if (!this.llListeners.contains(eventListener)) {
                this.llListeners.add(eventListener);
            }
        }
        finally {
            this.W_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(EventListener eventListener) {
        if (eventListener == null) {
            return;
        }
        this.W_LOCK.lock();
        try {
            if (DEBUG) {
                String string = "{0} [AbstractEvent.removeListener] TotalListeners=''{3}'' Thread=''{1}'' EventListener=''{2}(@{4})''";
                String[] stringArray = new String[]{DateUtil.getLogTime(), Thread.currentThread().getName(), eventListener.toString(), Integer.toString(this.llListeners.size()), Integer.toString(eventListener.hashCode())};
                String string2 = MessageFormat.format("{0} [AbstractEvent.removeListener] TotalListeners=''{3}'' Thread=''{1}'' EventListener=''{2}(@{4})''", stringArray);
                System.out.println(string2);
            }
            this.llListeners.remove(eventListener);
        }
        finally {
            this.W_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllListeners() {
        this.W_LOCK.lock();
        try {
            if (DEBUG) {
                String string = "{0} [AbstractEvent.removeAllListeners] TotalListeners=''{2}'' Thread=''{1}''";
                String[] stringArray = new String[]{DateUtil.getLogTime(), Thread.currentThread().getName(), Integer.toString(this.llListeners.size())};
                String string2 = MessageFormat.format("{0} [AbstractEvent.removeAllListeners] TotalListeners=''{2}'' Thread=''{1}''", stringArray);
                System.out.println(string2);
            }
            this.llListeners.clear();
        }
        finally {
            this.W_LOCK.unlock();
        }
    }
}

