/*
 * Decompiled with CFR 0.152.
 */
package com.dokandev.dokan.util;

import java.util.EnumSet;
import java.util.Set;

public enum FileFlag {
    FILE_FLAG_OPEN_NO_RECALL(0x100000),
    FILE_FLAG_OPEN_REPARSE_POINT(0x200000),
    FILE_FLAG_SESSION_AWARE(0x800000),
    FILE_FLAG_POSIX_SEMANTICS(0x1000000),
    FILE_FLAG_BACKUP_SEMANTICS(0x2000000),
    FILE_FLAG_DELETE_ON_CLOSE(0x4000000),
    FILE_FLAG_SEQUENTIAL_SCAN(0x8000000),
    FILE_FLAG_RANDOM_ACCESS(0x10000000),
    FILE_FLAG_NO_BUFFERING(0x20000000),
    FILE_FLAG_OVERLAPPED(0x40000000),
    FILE_FLAG_WRITE_THROUGH(Integer.MIN_VALUE);

    private final int mask;

    private FileFlag(int mask) {
        this.mask = mask;
    }

    public int mask() {
        return this.mask;
    }

    public static Set<FileFlag> fromInt(int flagsAndAttributes) {
        EnumSet<FileFlag> set = EnumSet.noneOf(FileFlag.class);
        for (FileFlag e : (FileFlag[])FileFlag.class.getEnumConstants()) {
            if ((e.mask() & flagsAndAttributes) != e.mask()) continue;
            set.add(e);
        }
        return set;
    }

    public static int toInt(FileFlag ... flags) {
        int mask = 0;
        for (FileFlag e : flags) {
            mask |= e.mask();
        }
        return mask;
    }

    public static String toString(int flagsAndAttributes) {
        String sRtn = "";
        for (FileFlag mask : FileFlag.fromInt(flagsAndAttributes)) {
            if (!"".equals(sRtn)) {
                sRtn = sRtn + " | ";
            }
            sRtn = sRtn + mask.name();
        }
        return "(" + String.valueOf(flagsAndAttributes) + ") " + sRtn;
    }
}

