/*
 * Decompiled with CFR 0.152.
 */
package com.dokandev.dokan.util;

import java.util.EnumSet;
import java.util.Set;

public enum FileAttribute {
    FILE_ATTRIBUTE_READONLY(1),
    FILE_ATTRIBUTE_HIDDEN(2),
    FILE_ATTRIBUTE_SYSTEM(4),
    FILE_ATTRIBUTE_DIRECTORY(16),
    FILE_ATTRIBUTE_ARCHIVE(32),
    FILE_ATTRIBUTE_DEVICE(64),
    FILE_ATTRIBUTE_NORMAL(128),
    FILE_ATTRIBUTE_TEMPORARY(256),
    FILE_ATTRIBUTE_SPARSE_FILE(512),
    FILE_ATTRIBUTE_REPARSE_POINT(1024),
    FILE_ATTRIBUTE_COMPRESSED(2048),
    FILE_ATTRIBUTE_OFFLINE(4096),
    FILE_ATTRIBUTE_NOT_CONTENT_INDEXED(8192),
    FILE_ATTRIBUTE_ENCRYPTED(16384),
    FILE_ATTRIBUTE_INTEGRITY_STREAM(32768),
    FILE_ATTRIBUTE_VIRTUAL(65536),
    FILE_ATTRIBUTE_NO_SCRUB_DATA(131072);

    private final int value;

    private FileAttribute(int value) {
        this.value = value;
    }

    public int mask() {
        return this.value;
    }

    public static Set<FileAttribute> fromInt(int flagsAndAttributes) {
        EnumSet<FileAttribute> set = EnumSet.noneOf(FileAttribute.class);
        for (FileAttribute e : (FileAttribute[])FileAttribute.class.getEnumConstants()) {
            if ((e.mask() & flagsAndAttributes) != e.mask()) continue;
            set.add(e);
        }
        return set;
    }

    public static int toInt(FileAttribute ... attributes) {
        int mask = 0;
        for (FileAttribute e : attributes) {
            mask |= e.mask();
        }
        return mask;
    }

    public static String toString(int flagsAndAttributes) {
        String sRtn = "";
        for (FileAttribute mask : FileAttribute.fromInt(flagsAndAttributes)) {
            if (!"".equals(sRtn)) {
                sRtn = sRtn + " | ";
            }
            sRtn = sRtn + mask.name();
        }
        return "(" + String.valueOf(flagsAndAttributes) + ") " + sRtn;
    }
}

