/*
 * Decompiled with CFR 0.152.
 */
package net.extg.cabinetmaker;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import net.extg.cabinetmaker.CabFile;

public class CabinetMakerExample {
    public static final String FILENAME_1 = "file1.txt";
    public static final String FILENAME_2 = "file2.txt";
    public static final String FILENAME_3 = "file3.txt";
    public static final String FILENAME_4 = "file4.txt";

    public static void main(String[] args) throws Exception {
        File f1 = new File(FILENAME_1);
        FileInputStream is1 = new FileInputStream(f1);
        long length1 = f1.length();
        File f2 = new File(FILENAME_2);
        FileInputStream is2 = new FileInputStream(f2);
        long length2 = f2.length();
        File f3 = new File(FILENAME_3);
        FileInputStream is3 = new FileInputStream(f3);
        long length3 = f3.length();
        byte[] file1 = CabinetMakerExample.readBytesFromFile(is1, length1);
        byte[] file2 = CabinetMakerExample.readBytesFromFile(is2, length2);
        byte[] file3 = CabinetMakerExample.readBytesFromFile(is3, length3);
        Vector<String> filenames = new Vector<String>();
        Vector<byte[]> files = new Vector<byte[]>();
        filenames.add(FILENAME_1);
        filenames.add(FILENAME_2);
        filenames.add(FILENAME_3);
        files.add(file1);
        files.add(file2);
        files.add(file3);
        CabFile c = new CabFile(filenames, files);
        FileOutputStream fs = new FileOutputStream(new File("out.cab"));
        fs.write(c.getCabFile());
        fs.close();
    }

    private static byte[] readBytesFromFile(FileInputStream is, long length) throws IOException {
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (int offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        is.close();
        return bytes;
    }
}

