/*
 * Decompiled with CFR 0.152.
 */
package net.extg.cabinetmaker;

import java.util.Vector;

public class CFData {
    private int csum;
    private int cbData;
    private int cbUncomp;
    private Vector<Byte> ab;

    public CFData(Vector<Byte> data) {
        this.ab = data;
        this.cbData = this.ab.size();
        this.cbUncomp = this.ab.size();
        this.csum = 0;
        this.csum = this.calculateChecksum();
    }

    public Vector<Byte> makeByteArray() {
        Vector<Byte> b = new Vector<Byte>();
        b.addAll(this.convertToByte(this.csum, 4));
        b.addAll(this.convertToByte(this.cbData, 2));
        b.addAll(this.convertToByte(this.cbUncomp, 2));
        b.addAll(this.ab);
        return b;
    }

    private Vector<Byte> convertToByte(int val, int numBytes) {
        Vector<Byte> b = new Vector<Byte>();
        if (numBytes == 1) {
            Integer tempInt = new Integer(val);
            Byte byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
        } else if (numBytes == 2) {
            Integer tempInt = new Integer(0xFF & val);
            Byte byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
            tempInt = new Integer((0xFF00 & val) >>> 8);
            byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
        } else if (numBytes == 3) {
            Integer tempInt = new Integer(0xFF & val);
            Byte byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
            tempInt = new Integer((0xFF00 & val) >>> 8);
            byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
            tempInt = new Integer((0xFF0000 & val) >>> 16);
            byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
        } else if (numBytes == 4) {
            Integer tempInt = new Integer(0xFF & val);
            Byte byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
            tempInt = new Integer((0xFF00 & val) >>> 8);
            byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
            tempInt = new Integer((0xFF0000 & val) >>> 16);
            byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
            tempInt = new Integer((0xFF000000 & val) >>> 24);
            byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
        } else {
            b.add(new Byte("255"));
        }
        return b;
    }

    private int calculateChecksum() {
        byte[] arrayOfByte = new byte[]{(byte)(this.cbData & 0xFF), (byte)(this.cbData >>> 8 & 0xFF), (byte)(this.cbUncomp & 0xFF), (byte)(this.cbUncomp >>> 8 & 0xFF)};
        byte[] bytes = new byte[this.ab.size()];
        for (int i = 0; i < this.ab.size(); ++i) {
            bytes[i] = this.ab.get(i);
        }
        return this.calculate(bytes, this.cbData, this.calculate(arrayOfByte, 4, 0));
    }

    private int calculate(byte[] bytes, int currentBlock, int seed) {
        byte c1 = (byte)(seed & 0xFF);
        byte c2 = (byte)(seed >>> 8 & 0xFF);
        byte c3 = (byte)(seed >>> 16 & 0xFF);
        byte c4 = (byte)(seed >>> 24 & 0xFF);
        int j = 0;
        int sizeOfBlock = currentBlock >>> 2;
        while (sizeOfBlock-- > 0) {
            c1 = (byte)(c1 ^ bytes[j++]);
            c2 = (byte)(c2 ^ bytes[j++]);
            c3 = (byte)(c3 ^ bytes[j++]);
            c4 = (byte)(c4 ^ bytes[j++]);
        }
        switch (currentBlock & 3) {
            case 3: {
                c3 = (byte)(c3 ^ bytes[j++]);
            }
            case 2: {
                c2 = (byte)(c2 ^ bytes[j++]);
            }
            case 1: {
                c1 = (byte)(c1 ^ bytes[j++]);
            }
        }
        return c1 & 0xFF | (c2 & 0xFF) << 8 | (c3 & 0xFF) << 16 | (c4 & 0xFF) << 24;
    }
}

