/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles2.commands;

import jakarta.servlet.ServletContext;
import org.apache.commons.chain.Command;
import org.apache.struts.chain.contexts.ServletActionContext;
import org.apache.struts.config.ForwardConfig;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.jakarta.servlet.ServletRequest;
import org.apache.tiles.request.jakarta.servlet.ServletUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TilesPreProcessor
implements Command<ServletActionContext> {
    private final Logger log = LoggerFactory.getLogger(TilesPreProcessor.class);

    public boolean execute(ServletActionContext sacontext) throws Exception {
        ForwardConfig forwardConfig = sacontext.getForwardConfig();
        if (forwardConfig == null || forwardConfig.getPath() == null) {
            this.log.debug("No forwardConfig or no path, so pass to next command.");
            return false;
        }
        ApplicationContext applicationContext = ServletUtil.getApplicationContext((ServletContext)sacontext.getContext());
        ServletRequest request = new ServletRequest(applicationContext, sacontext.getRequest(), sacontext.getResponse());
        TilesContainer container = TilesAccess.getContainer((ApplicationContext)applicationContext);
        if (container == null) {
            this.log.debug("Tiles container not found, so pass to next command.");
            return false;
        }
        if (container.isValidDefinition(forwardConfig.getPath(), (Request)request)) {
            container.render(forwardConfig.getPath(), (Request)request);
            sacontext.setForwardConfig(null);
        } else {
            this.log.debug("Cannot find definition '{}'", (Object)forwardConfig.getPath());
        }
        return false;
    }
}

