/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles2;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.TilesException;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.jakarta.servlet.ServletRequest;
import org.apache.tiles.request.jakarta.servlet.ServletUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TilesRequestProcessor
extends RequestProcessor {
    private static final long serialVersionUID = 6212184689866961850L;
    private final transient Logger log = LoggerFactory.getLogger(TilesRequestProcessor.class);
    protected ServletContext servletContext;

    public void init(ActionServlet servlet, ModuleConfig moduleConfig) throws ServletException {
        super.init(servlet, moduleConfig);
    }

    protected boolean processTilesDefinition(String definitionName, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        ApplicationContext applicationContext = ServletUtil.getApplicationContext((ServletContext)this.getServletContext());
        ServletRequest request = new ServletRequest(applicationContext, req, res);
        TilesContainer container = TilesAccess.getContainer((ApplicationContext)applicationContext);
        if (container == null) {
            this.log.debug("Tiles container not found, so pass to next command.");
            return false;
        }
        boolean retValue = false;
        if (container.isValidDefinition(definitionName, (Request)request)) {
            retValue = true;
            try {
                container.render(definitionName, (Request)request);
            }
            catch (TilesException e) {
                throw new ServletException("Cannot render definition '" + definitionName + "'");
            }
        } else {
            this.log.debug("Cannot find definition '{}'", (Object)definitionName);
        }
        return retValue;
    }

    protected void doForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (response.isCommitted()) {
            this.doInclude(uri, request, response);
        } else {
            super.doForward(uri, request, response);
        }
    }

    protected void processForwardConfig(HttpServletRequest request, HttpServletResponse response, ForwardConfig forward) throws IOException, ServletException {
        if (forward == null) {
            return;
        }
        this.log.debug("processForwardConfig({})", (Object)forward.getPath());
        if (this.processTilesDefinition(forward.getPath(), request, response)) {
            this.log.debug("  '{}' - processed as definition", (Object)forward.getPath());
            return;
        }
        this.log.debug("  '{}' - processed as uri", (Object)forward.getPath());
        super.processForwardConfig(request, response, forward);
    }

    protected void internalModuleRelativeForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.processTilesDefinition(uri, request, response)) {
            return;
        }
        super.internalModuleRelativeForward(uri, request, response);
    }

    protected void internalModuleRelativeInclude(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.processTilesDefinition(uri, request, response)) {
            return;
        }
        super.internalModuleRelativeInclude(uri, request, response);
    }
}

