/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.privatedns.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Resource;
import com.azure.resourcemanager.privatedns.PrivateDnsZoneManager;
import com.azure.resourcemanager.privatedns.fluent.PrivateDnsManagementClient;
import com.azure.resourcemanager.privatedns.fluent.models.PrivateZoneInner;
import com.azure.resourcemanager.privatedns.fluent.models.RecordSetInner;
import com.azure.resourcemanager.privatedns.implementation.ARecordSetImpl;
import com.azure.resourcemanager.privatedns.implementation.ARecordSetsImpl;
import com.azure.resourcemanager.privatedns.implementation.AaaaRecordSetImpl;
import com.azure.resourcemanager.privatedns.implementation.AaaaRecordSetsImpl;
import com.azure.resourcemanager.privatedns.implementation.CnameRecordSetImpl;
import com.azure.resourcemanager.privatedns.implementation.CnameRecordSetsImpl;
import com.azure.resourcemanager.privatedns.implementation.MxRecordSetImpl;
import com.azure.resourcemanager.privatedns.implementation.MxRecordSetsImpl;
import com.azure.resourcemanager.privatedns.implementation.PrivateDnsRecordSetImpl;
import com.azure.resourcemanager.privatedns.implementation.PrivateDnsRecordSetsImpl;
import com.azure.resourcemanager.privatedns.implementation.PtrRecordSetImpl;
import com.azure.resourcemanager.privatedns.implementation.PtrRecordSetsImpl;
import com.azure.resourcemanager.privatedns.implementation.SoaRecordSetImpl;
import com.azure.resourcemanager.privatedns.implementation.SrvRecordSetImpl;
import com.azure.resourcemanager.privatedns.implementation.SrvRecordSetsImpl;
import com.azure.resourcemanager.privatedns.implementation.TxtRecordSetImpl;
import com.azure.resourcemanager.privatedns.implementation.TxtRecordSetsImpl;
import com.azure.resourcemanager.privatedns.implementation.VirtualNetworkLinkImpl;
import com.azure.resourcemanager.privatedns.implementation.VirtualNetworkLinksImpl;
import com.azure.resourcemanager.privatedns.models.ARecordSets;
import com.azure.resourcemanager.privatedns.models.AaaaRecordSets;
import com.azure.resourcemanager.privatedns.models.CnameRecordSets;
import com.azure.resourcemanager.privatedns.models.MxRecordSets;
import com.azure.resourcemanager.privatedns.models.PrivateDnsRecordSet;
import com.azure.resourcemanager.privatedns.models.PrivateDnsZone;
import com.azure.resourcemanager.privatedns.models.ProvisioningState;
import com.azure.resourcemanager.privatedns.models.PtrRecordSets;
import com.azure.resourcemanager.privatedns.models.RecordType;
import com.azure.resourcemanager.privatedns.models.SoaRecordSet;
import com.azure.resourcemanager.privatedns.models.SrvRecordSets;
import com.azure.resourcemanager.privatedns.models.TxtRecordSets;
import com.azure.resourcemanager.privatedns.models.VirtualNetworkLinks;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ETagState;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Mono;

class PrivateDnsZoneImpl
extends GroupableResourceImpl<PrivateDnsZone, PrivateZoneInner, PrivateDnsZoneImpl, PrivateDnsZoneManager>
implements PrivateDnsZone,
PrivateDnsZone.Definition,
PrivateDnsZone.Update {
    private AaaaRecordSets aaaaRecordSets;
    private ARecordSets aRecordSets;
    private CnameRecordSets cnameRecordSets;
    private MxRecordSets mxRecordSets;
    private PtrRecordSets ptrRecordSets;
    private SrvRecordSets srvRecordSets;
    private TxtRecordSets txtRecordSets;
    private PrivateDnsRecordSetsImpl recordSets;
    private VirtualNetworkLinksImpl virtualNetworkLinks;
    private final ETagState etagState = new ETagState();
    private Map<String, String> resourceTagsSnapshotOnUpdate = null;

    PrivateDnsZoneImpl(String name, PrivateZoneInner innerModel, PrivateDnsZoneManager manager) {
        super(name, (Resource)innerModel, (Manager)manager);
        this.recordSets = new PrivateDnsRecordSetsImpl(this);
        this.virtualNetworkLinks = new VirtualNetworkLinksImpl(this);
        this.initRecordSets();
    }

    private void initRecordSets() {
        this.aaaaRecordSets = new AaaaRecordSetsImpl(this);
        this.aRecordSets = new ARecordSetsImpl(this);
        this.cnameRecordSets = new CnameRecordSetsImpl(this);
        this.mxRecordSets = new MxRecordSetsImpl(this);
        this.ptrRecordSets = new PtrRecordSetsImpl(this);
        this.srvRecordSets = new SrvRecordSetsImpl(this);
        this.txtRecordSets = new TxtRecordSetsImpl(this);
    }

    @Override
    public String etag() {
        return ((PrivateZoneInner)((Object)this.innerModel())).etag();
    }

    @Override
    public long maxNumberOfRecordSets() {
        return ResourceManagerUtils.toPrimitiveLong((Long)((PrivateZoneInner)((Object)this.innerModel())).maxNumberOfRecordSets());
    }

    @Override
    public long numberOfRecordSets() {
        return ResourceManagerUtils.toPrimitiveLong((Long)((PrivateZoneInner)((Object)this.innerModel())).numberOfRecordSets());
    }

    @Override
    public long maxNumberOfVirtualNetworkLinks() {
        return ResourceManagerUtils.toPrimitiveLong((Long)((PrivateZoneInner)((Object)this.innerModel())).maxNumberOfVirtualNetworkLinks());
    }

    @Override
    public long numberOfVirtualNetworkLinks() {
        return ResourceManagerUtils.toPrimitiveLong((Long)((PrivateZoneInner)((Object)this.innerModel())).numberOfVirtualNetworkLinks());
    }

    @Override
    public long maxNumberOfVirtualNetworkLinksWithRegistration() {
        return ResourceManagerUtils.toPrimitiveLong((Long)((PrivateZoneInner)((Object)this.innerModel())).maxNumberOfVirtualNetworkLinksWithRegistration());
    }

    @Override
    public long numberOfVirtualNetworkLinksWithRegistration() {
        return ResourceManagerUtils.toPrimitiveLong((Long)((PrivateZoneInner)((Object)this.innerModel())).numberOfVirtualNetworkLinksWithRegistration());
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((PrivateZoneInner)((Object)this.innerModel())).provisioningState();
    }

    @Override
    public PagedIterable<PrivateDnsRecordSet> listRecordSets() {
        return this.listRecordSetsIntern(null, null);
    }

    @Override
    public PagedFlux<PrivateDnsRecordSet> listRecordSetsAsync() {
        return this.listRecordSetsInternAsync(null, null);
    }

    @Override
    public PagedIterable<PrivateDnsRecordSet> listRecordSets(String recordSetNameSuffix) {
        return this.listRecordSetsIntern(recordSetNameSuffix, null);
    }

    @Override
    public PagedFlux<PrivateDnsRecordSet> listRecordSetsAsync(String recordSetNameSuffix) {
        return this.listRecordSetsInternAsync(recordSetNameSuffix, null);
    }

    @Override
    public PagedIterable<PrivateDnsRecordSet> listRecordSets(int pageSize) {
        return this.listRecordSetsIntern(null, pageSize);
    }

    @Override
    public PagedFlux<PrivateDnsRecordSet> listRecordSetsAsync(int pageSize) {
        return this.listRecordSetsInternAsync(null, pageSize);
    }

    @Override
    public PagedIterable<PrivateDnsRecordSet> listRecordSets(String recordSetNameSuffix, int pageSize) {
        return this.listRecordSetsIntern(recordSetNameSuffix, pageSize);
    }

    @Override
    public PagedFlux<PrivateDnsRecordSet> listRecordSetsAsync(String recordSetNameSuffix, int pageSize) {
        return this.listRecordSetsInternAsync(recordSetNameSuffix, pageSize);
    }

    @Override
    public AaaaRecordSets aaaaRecordSets() {
        return this.aaaaRecordSets;
    }

    @Override
    public ARecordSets aRecordSets() {
        return this.aRecordSets;
    }

    @Override
    public CnameRecordSets cnameRecordSets() {
        return this.cnameRecordSets;
    }

    @Override
    public MxRecordSets mxRecordSets() {
        return this.mxRecordSets;
    }

    @Override
    public PtrRecordSets ptrRecordSets() {
        return this.ptrRecordSets;
    }

    @Override
    public SoaRecordSet getSoaRecordSet() {
        RecordSetInner inner = ((PrivateDnsManagementClient)((PrivateDnsZoneManager)this.manager()).serviceClient()).getRecordSets().get(this.resourceGroupName(), this.name(), RecordType.SOA, "@");
        return inner == null ? null : new SoaRecordSetImpl(inner.name(), this, inner);
    }

    @Override
    public SrvRecordSets srvRecordSets() {
        return this.srvRecordSets;
    }

    @Override
    public TxtRecordSets txtRecordSets() {
        return this.txtRecordSets;
    }

    @Override
    public VirtualNetworkLinks virtualNetworkLinks() {
        return this.virtualNetworkLinks;
    }

    public PrivateDnsRecordSetImpl defineAaaaRecordSet(String name) {
        return this.recordSets.defineAaaaRecordSet(name);
    }

    public PrivateDnsRecordSetImpl defineARecordSet(String name) {
        return this.recordSets.defineARecordSet(name);
    }

    @Override
    public PrivateDnsZoneImpl withCnameRecordSet(String name, String alias) {
        this.recordSets.withCnameRecordSet(name, alias);
        return this;
    }

    public PrivateDnsRecordSetImpl defineCnameRecordSet(String name) {
        return this.recordSets.defineCnameRecordSet(name);
    }

    public PrivateDnsRecordSetImpl defineMxRecordSet(String name) {
        return this.recordSets.defineMxRecordSet(name);
    }

    public PrivateDnsRecordSetImpl definePtrRecordSet(String name) {
        return this.recordSets.definePtrRecordSet(name);
    }

    public PrivateDnsRecordSetImpl defineSoaRecordSet() {
        return this.recordSets.defineSoaRecordSet();
    }

    public PrivateDnsRecordSetImpl defineSrvRecordSet(String name) {
        return this.recordSets.defineSrvRecordSet(name);
    }

    public PrivateDnsRecordSetImpl defineTxtRecordSet(String name) {
        return this.recordSets.defineTxtRecordSet(name);
    }

    @Override
    public PrivateDnsRecordSetImpl updateAaaaRecordSet(String name) {
        return this.recordSets.updateAaaaRecordSet(name);
    }

    @Override
    public PrivateDnsRecordSetImpl updateARecordSet(String name) {
        return this.recordSets.updateARecordSet(name);
    }

    @Override
    public PrivateDnsRecordSetImpl updateCnameRecordSet(String name) {
        return this.recordSets.updateCnameRecordSet(name);
    }

    @Override
    public PrivateDnsRecordSetImpl updateMxRecordSet(String name) {
        return this.recordSets.updateMxRecordSet(name);
    }

    @Override
    public PrivateDnsRecordSetImpl updatePtrRecordSet(String name) {
        return this.recordSets.updatePtrRecordSet(name);
    }

    @Override
    public PrivateDnsRecordSetImpl updateSoaRecord() {
        return this.recordSets.updateSoaRecordSet();
    }

    @Override
    public PrivateDnsRecordSetImpl updateSrvRecordSet(String name) {
        return this.recordSets.updateSrvRecordSet(name);
    }

    @Override
    public PrivateDnsRecordSetImpl updateTxtRecordSet(String name) {
        return this.recordSets.updateTxtRecordSet(name);
    }

    @Override
    public PrivateDnsZoneImpl withoutAaaaRecordSet(String name) {
        return this.withoutAaaaRecordSet(name, null);
    }

    @Override
    public PrivateDnsZoneImpl withoutAaaaRecordSet(String name, String etagValue) {
        this.recordSets.withoutAaaaRecordSet(name, etagValue);
        return this;
    }

    @Override
    public PrivateDnsZoneImpl withoutARecordSet(String name) {
        return this.withoutARecordSet(name, null);
    }

    @Override
    public PrivateDnsZoneImpl withoutARecordSet(String name, String etagValue) {
        this.recordSets.withoutARecordSet(name, etagValue);
        return this;
    }

    @Override
    public PrivateDnsZoneImpl withoutCNameRecordSet(String name) {
        return this.withoutCNameRecordSet(name, null);
    }

    @Override
    public PrivateDnsZoneImpl withoutCNameRecordSet(String name, String etagValue) {
        this.recordSets.withoutCnameRecordSet(name, etagValue);
        return this;
    }

    @Override
    public PrivateDnsZoneImpl withoutMXRecordSet(String name) {
        return this.withoutMXRecordSet(name, null);
    }

    @Override
    public PrivateDnsZoneImpl withoutMXRecordSet(String name, String etagValue) {
        this.recordSets.withoutMxRecordSet(name, etagValue);
        return this;
    }

    @Override
    public PrivateDnsZoneImpl withoutPtrRecordSet(String name) {
        return this.withoutPtrRecordSet(name, null);
    }

    @Override
    public PrivateDnsZoneImpl withoutPtrRecordSet(String name, String etagValue) {
        this.recordSets.withoutPtrRecordSet(name, etagValue);
        return this;
    }

    @Override
    public PrivateDnsZoneImpl withoutSrvRecordSet(String name) {
        return this.withoutSrvRecordSet(name, null);
    }

    @Override
    public PrivateDnsZoneImpl withoutSrvRecordSet(String name, String etagValue) {
        this.recordSets.withoutSrvRecordSet(name, etagValue);
        return this;
    }

    @Override
    public PrivateDnsZoneImpl withoutTxtRecordSet(String name) {
        return this.withoutTxtRecordSet(name, null);
    }

    @Override
    public PrivateDnsZoneImpl withoutTxtRecordSet(String name, String etagValue) {
        this.recordSets.withoutTxtRecordSet(name, etagValue);
        return this;
    }

    public VirtualNetworkLinkImpl defineVirtualNetworkLink(String name) {
        return this.virtualNetworkLinks.defineVirtualNetworkLink(name);
    }

    @Override
    public VirtualNetworkLinkImpl updateVirtualNetworkLink(String name) {
        return this.virtualNetworkLinks.updateVirtualNetworkLink(name);
    }

    @Override
    public PrivateDnsZoneImpl withoutVirtualNetworkLink(String name) {
        return this.withoutVirtualNetworkLink(name, null);
    }

    @Override
    public PrivateDnsZoneImpl withoutVirtualNetworkLink(String name, String etagValue) {
        this.virtualNetworkLinks.withoutVirtualNetworkLink(name, etagValue);
        return this;
    }

    @Override
    public PrivateDnsZoneImpl withETagCheck() {
        this.etagState.withImplicitETagCheckOnCreateOrUpdate(this.isInCreateMode());
        return this;
    }

    @Override
    public PrivateDnsZone.Update withETagCheck(String etagValue) {
        this.etagState.withExplicitETagCheckOnUpdate(etagValue);
        return this;
    }

    public Mono<PrivateDnsZone> createResourceAsync() {
        Mono mono = this.isInCreateMode() ? ((PrivateDnsManagementClient)((PrivateDnsZoneManager)this.manager()).serviceClient()).getPrivateZones().createOrUpdateAsync(this.resourceGroupName(), this.name(), (PrivateZoneInner)((Object)this.innerModel()), this.etagState.ifMatchValueOnUpdate(((PrivateZoneInner)((Object)this.innerModel())).etag()), this.etagState.ifNonMatchValueOnCreate()).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)) : (!Objects.equals(this.resourceTagsSnapshotOnUpdate, ((PrivateZoneInner)((Object)this.innerModel())).tags()) ? ((PrivateDnsManagementClient)((PrivateDnsZoneManager)this.manager()).serviceClient()).getPrivateZones().updateAsync(this.resourceGroupName(), this.name(), (PrivateZoneInner)((Object)this.innerModel()), this.etagState.ifMatchValueOnUpdate(((PrivateZoneInner)((Object)this.innerModel())).etag())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)) : Mono.just((Object)this));
        return mono.map(privateDnsZone -> {
            this.etagState.clear();
            return privateDnsZone;
        });
    }

    public PrivateDnsZoneImpl update() {
        this.resourceTagsSnapshotOnUpdate = this.innerModel() != null && ((PrivateZoneInner)((Object)this.innerModel())).tags() != null ? new HashMap<String, String>(((PrivateZoneInner)((Object)this.innerModel())).tags()) : null;
        return (PrivateDnsZoneImpl)super.update();
    }

    public Mono<Void> afterPostRunAsync(boolean isGroupFaulted) {
        return Mono.just((Object)true).map(ignored -> {
            this.recordSets.clear();
            this.virtualNetworkLinks.clear();
            return ignored;
        }).then();
    }

    public Mono<PrivateDnsZone> refreshAsync() {
        return super.refreshAsync().map(privateDnsZone -> {
            PrivateDnsZoneImpl impl = (PrivateDnsZoneImpl)privateDnsZone;
            impl.initRecordSets();
            return impl;
        });
    }

    protected Mono<PrivateZoneInner> getInnerAsync() {
        return ((PrivateDnsManagementClient)((PrivateDnsZoneManager)this.manager()).serviceClient()).getPrivateZones().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    private PagedIterable<PrivateDnsRecordSet> listRecordSetsIntern(String recordSetSuffix, Integer pageSize) {
        return new PagedIterable(this.listRecordSetsInternAsync(recordSetSuffix, pageSize));
    }

    private PagedFlux<PrivateDnsRecordSet> listRecordSetsInternAsync(String recordSetSuffix, Integer pageSize) {
        PrivateDnsZoneImpl self = this;
        return PagedConverter.mapPage(((PrivateDnsManagementClient)((PrivateDnsZoneManager)this.manager()).serviceClient()).getRecordSets().listAsync(this.resourceGroupName(), this.name(), pageSize, recordSetSuffix), recordSetInner -> {
            PrivateDnsRecordSetImpl recordSet = new PrivateDnsRecordSetImpl(recordSetInner.name(), recordSetInner.type(), self, (RecordSetInner)((Object)recordSetInner));
            switch (recordSet.recordType()) {
                case AAAA: {
                    return new AaaaRecordSetImpl(recordSetInner.name(), self, (RecordSetInner)((Object)recordSetInner));
                }
                case A: {
                    return new ARecordSetImpl(recordSetInner.name(), self, (RecordSetInner)((Object)recordSetInner));
                }
                case CNAME: {
                    return new CnameRecordSetImpl(recordSetInner.name(), self, (RecordSetInner)((Object)recordSetInner));
                }
                case MX: {
                    return new MxRecordSetImpl(recordSetInner.name(), self, (RecordSetInner)((Object)recordSetInner));
                }
                case PTR: {
                    return new PtrRecordSetImpl(recordSetInner.name(), self, (RecordSetInner)((Object)recordSetInner));
                }
                case SOA: {
                    return new SoaRecordSetImpl(recordSetInner.name(), self, (RecordSetInner)((Object)recordSetInner));
                }
                case SRV: {
                    return new SrvRecordSetImpl(recordSetInner.name(), self, (RecordSetInner)((Object)recordSetInner));
                }
                case TXT: {
                    return new TxtRecordSetImpl(recordSetInner.name(), self, (RecordSetInner)((Object)recordSetInner));
                }
            }
            return recordSet;
        });
    }
}

