/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition.pattern;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.tiles.Definition;
import org.apache.tiles.Expression;
import org.apache.tiles.definition.pattern.AbstractPatternDefinitionResolver;
import org.apache.tiles.definition.pattern.DefinitionPatternMatcher;
import org.apache.tiles.definition.pattern.DefinitionPatternMatcherFactory;
import org.apache.tiles.definition.pattern.PatternUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixedPatternDefinitionResolver<T>
extends AbstractPatternDefinitionResolver<T> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, DefinitionPatternMatcherFactory> language2matcherFactory = new HashMap<String, DefinitionPatternMatcherFactory>();

    public void registerDefinitionPatternMatcherFactory(String language, DefinitionPatternMatcherFactory factory) {
        this.language2matcherFactory.put(language, factory);
    }

    @Override
    protected Map<String, Definition> addDefinitionsAsPatternMatchers(List<DefinitionPatternMatcher> matchers, Map<String, Definition> defsMap) {
        LinkedHashSet<String> excludedKeys = new LinkedHashSet<String>();
        for (Map.Entry<String, Definition> entry : defsMap.entrySet()) {
            String key = entry.getKey();
            Expression expression = Expression.createExpressionFromDescribedExpression((String)key);
            if (expression.getLanguage() != null) {
                DefinitionPatternMatcherFactory factory = this.language2matcherFactory.get(expression.getLanguage());
                if (factory != null) {
                    DefinitionPatternMatcher matcher = factory.createDefinitionPatternMatcher(expression.getExpression(), new Definition(entry.getValue()));
                    matchers.add(matcher);
                    continue;
                }
                this.logger.warn("Cannot find a DefinitionPatternMatcherFactory for expression '{}'", (Object)key);
                continue;
            }
            excludedKeys.add(key);
        }
        return PatternUtil.createExtractedMap(defsMap, excludedKeys);
    }
}

