/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamlog.FileRequestDetails;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FileRequestReceiveFileDetails {
    @Nullable
    protected final String fileRequestId;
    @Nullable
    protected final FileRequestDetails fileRequestDetails;
    @Nonnull
    protected final List<String> submittedFileNames;
    @Nullable
    protected final String submitterName;
    @Nullable
    protected final String submitterEmail;

    public FileRequestReceiveFileDetails(@Nonnull List<String> submittedFileNames, @Nullable String fileRequestId, @Nullable FileRequestDetails fileRequestDetails, @Nullable String submitterName, @Nullable String submitterEmail) {
        if (fileRequestId != null) {
            if (fileRequestId.length() < 1) {
                throw new IllegalArgumentException("String 'fileRequestId' is shorter than 1");
            }
            if (!Pattern.matches("[-_0-9a-zA-Z]+", fileRequestId)) {
                throw new IllegalArgumentException("String 'fileRequestId' does not match pattern");
            }
        }
        this.fileRequestId = fileRequestId;
        this.fileRequestDetails = fileRequestDetails;
        if (submittedFileNames == null) {
            throw new IllegalArgumentException("Required value for 'submittedFileNames' is null");
        }
        for (String x : submittedFileNames) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'submittedFileNames' is null");
        }
        this.submittedFileNames = submittedFileNames;
        this.submitterName = submitterName;
        if (submitterEmail != null && submitterEmail.length() > 255) {
            throw new IllegalArgumentException("String 'submitterEmail' is longer than 255");
        }
        this.submitterEmail = submitterEmail;
    }

    public FileRequestReceiveFileDetails(@Nonnull List<String> submittedFileNames) {
        this(submittedFileNames, null, null, null, null);
    }

    @Nonnull
    public List<String> getSubmittedFileNames() {
        return this.submittedFileNames;
    }

    @Nullable
    public String getFileRequestId() {
        return this.fileRequestId;
    }

    @Nullable
    public FileRequestDetails getFileRequestDetails() {
        return this.fileRequestDetails;
    }

    @Nullable
    public String getSubmitterName() {
        return this.submitterName;
    }

    @Nullable
    public String getSubmitterEmail() {
        return this.submitterEmail;
    }

    public static Builder newBuilder(List<String> submittedFileNames) {
        return new Builder(submittedFileNames);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.fileRequestId, this.fileRequestDetails, this.submittedFileNames, this.submitterName, this.submitterEmail});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FileRequestReceiveFileDetails other = (FileRequestReceiveFileDetails)obj;
            return (this.submittedFileNames == other.submittedFileNames || this.submittedFileNames.equals(other.submittedFileNames)) && (this.fileRequestId == other.fileRequestId || this.fileRequestId != null && this.fileRequestId.equals(other.fileRequestId)) && (this.fileRequestDetails == other.fileRequestDetails || this.fileRequestDetails != null && this.fileRequestDetails.equals(other.fileRequestDetails)) && (this.submitterName == other.submitterName || this.submitterName != null && this.submitterName.equals(other.submitterName)) && (this.submitterEmail == other.submitterEmail || this.submitterEmail != null && this.submitterEmail.equals(other.submitterEmail));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FileRequestReceiveFileDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FileRequestReceiveFileDetails value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("submitted_file_names");
            StoneSerializers.list(StoneSerializers.string()).serialize(value.submittedFileNames, g);
            if (value.fileRequestId != null) {
                g.writeFieldName("file_request_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.fileRequestId, g);
            }
            if (value.fileRequestDetails != null) {
                g.writeFieldName("file_request_details");
                StoneSerializers.nullableStruct(FileRequestDetails.Serializer.INSTANCE).serialize(value.fileRequestDetails, g);
            }
            if (value.submitterName != null) {
                g.writeFieldName("submitter_name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.submitterName, g);
            }
            if (value.submitterEmail != null) {
                g.writeFieldName("submitter_email");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.submitterEmail, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public FileRequestReceiveFileDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_submitterEmail;
            String f_submitterName;
            FileRequestDetails f_fileRequestDetails;
            String f_fileRequestId;
            List<String> f_submittedFileNames;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_submittedFileNames = null;
                f_fileRequestId = null;
                f_fileRequestDetails = null;
                f_submitterName = null;
                f_submitterEmail = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("submitted_file_names".equals(field)) {
                        f_submittedFileNames = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("file_request_id".equals(field)) {
                        f_fileRequestId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("file_request_details".equals(field)) {
                        f_fileRequestDetails = StoneSerializers.nullableStruct(FileRequestDetails.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("submitter_name".equals(field)) {
                        f_submitterName = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("submitter_email".equals(field)) {
                        f_submitterEmail = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_submittedFileNames == null) {
                    throw new JsonParseException(p, "Required field \"submitted_file_names\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FileRequestReceiveFileDetails value = new FileRequestReceiveFileDetails(f_submittedFileNames, f_fileRequestId, f_fileRequestDetails, f_submitterName, f_submitterEmail);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final List<String> submittedFileNames;
        protected String fileRequestId;
        protected FileRequestDetails fileRequestDetails;
        protected String submitterName;
        protected String submitterEmail;

        protected Builder(List<String> submittedFileNames) {
            if (submittedFileNames == null) {
                throw new IllegalArgumentException("Required value for 'submittedFileNames' is null");
            }
            for (String x : submittedFileNames) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'submittedFileNames' is null");
            }
            this.submittedFileNames = submittedFileNames;
            this.fileRequestId = null;
            this.fileRequestDetails = null;
            this.submitterName = null;
            this.submitterEmail = null;
        }

        public Builder withFileRequestId(String fileRequestId) {
            if (fileRequestId != null) {
                if (fileRequestId.length() < 1) {
                    throw new IllegalArgumentException("String 'fileRequestId' is shorter than 1");
                }
                if (!Pattern.matches("[-_0-9a-zA-Z]+", fileRequestId)) {
                    throw new IllegalArgumentException("String 'fileRequestId' does not match pattern");
                }
            }
            this.fileRequestId = fileRequestId;
            return this;
        }

        public Builder withFileRequestDetails(FileRequestDetails fileRequestDetails) {
            this.fileRequestDetails = fileRequestDetails;
            return this;
        }

        public Builder withSubmitterName(String submitterName) {
            this.submitterName = submitterName;
            return this;
        }

        public Builder withSubmitterEmail(String submitterEmail) {
            if (submitterEmail != null && submitterEmail.length() > 255) {
                throw new IllegalArgumentException("String 'submitterEmail' is longer than 255");
            }
            this.submitterEmail = submitterEmail;
            return this;
        }

        public FileRequestReceiveFileDetails build() {
            return new FileRequestReceiveFileDetails(this.submittedFileNames, this.fileRequestId, this.fileRequestDetails, this.submitterName, this.submitterEmail);
        }
    }
}

