/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

class GetTagsArg {
    @Nonnull
    protected final List<String> paths;

    public GetTagsArg(@Nonnull List<String> paths) {
        if (paths == null) {
            throw new IllegalArgumentException("Required value for 'paths' is null");
        }
        for (String x : paths) {
            if (x == null) {
                throw new IllegalArgumentException("An item in list 'paths' is null");
            }
            if (Pattern.matches("/(.|\\R)*", x)) continue;
            throw new IllegalArgumentException("Stringan item in list 'paths' does not match pattern");
        }
        this.paths = paths;
    }

    @Nonnull
    public List<String> getPaths() {
        return this.paths;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.paths});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            GetTagsArg other = (GetTagsArg)obj;
            return this.paths == other.paths || this.paths.equals(other.paths);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<GetTagsArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GetTagsArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("paths");
            StoneSerializers.list(StoneSerializers.string()).serialize(value.paths, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public GetTagsArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<String> f_paths;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_paths = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("paths".equals(field)) {
                        f_paths = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_paths == null) {
                    throw new JsonParseException(p, "Required field \"paths\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            GetTagsArg value = new GetTagsArg(f_paths);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

