/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.files.Metadata;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import javax.annotation.Nonnull;

public class GetCopyReferenceResult {
    @Nonnull
    protected final Metadata metadata;
    @Nonnull
    protected final String copyReference;
    @Nonnull
    protected final Date expires;

    public GetCopyReferenceResult(@Nonnull Metadata metadata, @Nonnull String copyReference, @Nonnull Date expires) {
        if (metadata == null) {
            throw new IllegalArgumentException("Required value for 'metadata' is null");
        }
        this.metadata = metadata;
        if (copyReference == null) {
            throw new IllegalArgumentException("Required value for 'copyReference' is null");
        }
        this.copyReference = copyReference;
        if (expires == null) {
            throw new IllegalArgumentException("Required value for 'expires' is null");
        }
        this.expires = LangUtil.truncateMillis(expires);
    }

    @Nonnull
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Nonnull
    public String getCopyReference() {
        return this.copyReference;
    }

    @Nonnull
    public Date getExpires() {
        return this.expires;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.metadata, this.copyReference, this.expires});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            GetCopyReferenceResult other = (GetCopyReferenceResult)obj;
            return !(this.metadata != other.metadata && !this.metadata.equals(other.metadata) || this.copyReference != other.copyReference && !this.copyReference.equals(other.copyReference) || this.expires != other.expires && !this.expires.equals(other.expires));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<GetCopyReferenceResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GetCopyReferenceResult value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("metadata");
            Metadata.Serializer.INSTANCE.serialize(value.metadata, g);
            g.writeFieldName("copy_reference");
            StoneSerializers.string().serialize(value.copyReference, g);
            g.writeFieldName("expires");
            StoneSerializers.timestamp().serialize(value.expires, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public GetCopyReferenceResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Date f_expires;
            String f_copyReference;
            Metadata f_metadata;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_metadata = null;
                f_copyReference = null;
                f_expires = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("metadata".equals(field)) {
                        f_metadata = (Metadata)Metadata.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("copy_reference".equals(field)) {
                        f_copyReference = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("expires".equals(field)) {
                        f_expires = StoneSerializers.timestamp().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_metadata == null) {
                    throw new JsonParseException(p, "Required field \"metadata\" missing.");
                }
                if (f_copyReference == null) {
                    throw new JsonParseException(p, "Required field \"copy_reference\" missing.");
                }
                if (f_expires == null) {
                    throw new JsonParseException(p, "Required field \"expires\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            GetCopyReferenceResult value = new GetCopyReferenceResult(f_metadata, f_copyReference, f_expires);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

