/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.fileproperties;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.fileproperties.PropertyGroupUpdate;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class UpdatePropertiesArg {
    @Nonnull
    protected final String path;
    @Nonnull
    protected final List<PropertyGroupUpdate> updatePropertyGroups;

    public UpdatePropertiesArg(@Nonnull String path, @Nonnull List<PropertyGroupUpdate> updatePropertyGroups) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        if (!Pattern.matches("/(.|\\R)*|id:.*|(ns:[0-9]+(/.*)?)", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        if (updatePropertyGroups == null) {
            throw new IllegalArgumentException("Required value for 'updatePropertyGroups' is null");
        }
        for (PropertyGroupUpdate x : updatePropertyGroups) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'updatePropertyGroups' is null");
        }
        this.updatePropertyGroups = updatePropertyGroups;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public List<PropertyGroupUpdate> getUpdatePropertyGroups() {
        return this.updatePropertyGroups;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.updatePropertyGroups});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            UpdatePropertiesArg other = (UpdatePropertiesArg)obj;
            return !(this.path != other.path && !this.path.equals(other.path) || this.updatePropertyGroups != other.updatePropertyGroups && !this.updatePropertyGroups.equals(other.updatePropertyGroups));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends StructSerializer<UpdatePropertiesArg> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(UpdatePropertiesArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("path");
            StoneSerializers.string().serialize(value.path, g);
            g.writeFieldName("update_property_groups");
            StoneSerializers.list(PropertyGroupUpdate.Serializer.INSTANCE).serialize(value.updatePropertyGroups, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public UpdatePropertiesArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<PropertyGroupUpdate> f_updatePropertyGroups;
            String f_path;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_path = null;
                f_updatePropertyGroups = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("update_property_groups".equals(field)) {
                        f_updatePropertyGroups = StoneSerializers.list(PropertyGroupUpdate.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_path == null) {
                    throw new JsonParseException(p, "Required field \"path\" missing.");
                }
                if (f_updatePropertyGroups == null) {
                    throw new JsonParseException(p, "Required field \"update_property_groups\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            UpdatePropertiesArg value = new UpdatePropertiesArg(f_path, f_updatePropertyGroups);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

