/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.DirectoryRolesDirectoryRolesClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryRole;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesDirectoryRoleExpand;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesDirectoryRoleOrderby;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesDirectoryRoleSelect;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryRoleInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

public final class DirectoryRolesDirectoryRolesClientImpl
implements DirectoryRolesDirectoryRolesClient {
    private final ClientLogger logger = new ClientLogger(DirectoryRolesDirectoryRolesClientImpl.class);
    private final DirectoryRolesDirectoryRolesService service;
    private final MicrosoftGraphClientImpl client;

    DirectoryRolesDirectoryRolesClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (DirectoryRolesDirectoryRolesService)RestProxy.create(DirectoryRolesDirectoryRolesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryRoleInner>> listDirectoryRoleSinglePageAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRolesDirectoryRoleOrderby> orderby, List<DirectoryRolesDirectoryRoleSelect> select, List<DirectoryRolesDirectoryRoleExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listDirectoryRole(this.client.getEndpoint(), top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryRole)res.getValue()).value(), ((CollectionOfDirectoryRole)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryRoleInner>> listDirectoryRoleSinglePageAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRolesDirectoryRoleOrderby> orderby, List<DirectoryRolesDirectoryRoleSelect> select, List<DirectoryRolesDirectoryRoleExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listDirectoryRole(this.client.getEndpoint(), top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryRole)res.getValue()).value(), ((CollectionOfDirectoryRole)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryRoleInner> listDirectoryRoleAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRolesDirectoryRoleOrderby> orderby, List<DirectoryRolesDirectoryRoleSelect> select, List<DirectoryRolesDirectoryRoleExpand> expand) {
        return new PagedFlux(() -> this.listDirectoryRoleSinglePageAsync(top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryRoleInner> listDirectoryRoleAsync() {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listDirectoryRoleSinglePageAsync(top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryRoleInner> listDirectoryRoleAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRolesDirectoryRoleOrderby> orderby, List<DirectoryRolesDirectoryRoleSelect> select, List<DirectoryRolesDirectoryRoleExpand> expand, Context context) {
        return new PagedFlux(() -> this.listDirectoryRoleSinglePageAsync(top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryRoleInner> listDirectoryRole() {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DirectoryRolesDirectoryRoleOrderby> orderby = null;
        List<DirectoryRolesDirectoryRoleSelect> select = null;
        List<DirectoryRolesDirectoryRoleExpand> expand = null;
        return new PagedIterable(this.listDirectoryRoleAsync(top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryRoleInner> listDirectoryRole(Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRolesDirectoryRoleOrderby> orderby, List<DirectoryRolesDirectoryRoleSelect> select, List<DirectoryRolesDirectoryRoleExpand> expand, Context context) {
        return new PagedIterable(this.listDirectoryRoleAsync(top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryRoleInner>> createDirectoryRoleWithResponseAsync(MicrosoftGraphDirectoryRoleInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createDirectoryRole(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryRoleInner>> createDirectoryRoleWithResponseAsync(MicrosoftGraphDirectoryRoleInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createDirectoryRole(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryRoleInner> createDirectoryRoleAsync(MicrosoftGraphDirectoryRoleInner body) {
        return this.createDirectoryRoleWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryRoleInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphDirectoryRoleInner createDirectoryRole(MicrosoftGraphDirectoryRoleInner body) {
        return (MicrosoftGraphDirectoryRoleInner)this.createDirectoryRoleAsync(body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryRoleInner> createDirectoryRoleWithResponse(MicrosoftGraphDirectoryRoleInner body, Context context) {
        return (Response)this.createDirectoryRoleWithResponseAsync(body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryRoleInner>> getDirectoryRoleWithResponseAsync(String directoryRoleId, List<DirectoryRolesDirectoryRoleSelect> select, List<DirectoryRolesDirectoryRoleExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getDirectoryRole(this.client.getEndpoint(), directoryRoleId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryRoleInner>> getDirectoryRoleWithResponseAsync(String directoryRoleId, List<DirectoryRolesDirectoryRoleSelect> select, List<DirectoryRolesDirectoryRoleExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getDirectoryRole(this.client.getEndpoint(), directoryRoleId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryRoleInner> getDirectoryRoleAsync(String directoryRoleId, List<DirectoryRolesDirectoryRoleSelect> select, List<DirectoryRolesDirectoryRoleExpand> expand) {
        return this.getDirectoryRoleWithResponseAsync(directoryRoleId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryRoleInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryRoleInner> getDirectoryRoleAsync(String directoryRoleId) {
        List<DirectoryRolesDirectoryRoleSelect> select = null;
        List<DirectoryRolesDirectoryRoleExpand> expand = null;
        return this.getDirectoryRoleWithResponseAsync(directoryRoleId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryRoleInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphDirectoryRoleInner getDirectoryRole(String directoryRoleId) {
        List<DirectoryRolesDirectoryRoleSelect> select = null;
        List<DirectoryRolesDirectoryRoleExpand> expand = null;
        return (MicrosoftGraphDirectoryRoleInner)this.getDirectoryRoleAsync(directoryRoleId, select, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryRoleInner> getDirectoryRoleWithResponse(String directoryRoleId, List<DirectoryRolesDirectoryRoleSelect> select, List<DirectoryRolesDirectoryRoleExpand> expand, Context context) {
        return (Response)this.getDirectoryRoleWithResponseAsync(directoryRoleId, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateDirectoryRoleWithResponseAsync(String directoryRoleId, MicrosoftGraphDirectoryRoleInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateDirectoryRole(this.client.getEndpoint(), directoryRoleId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateDirectoryRoleWithResponseAsync(String directoryRoleId, MicrosoftGraphDirectoryRoleInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateDirectoryRole(this.client.getEndpoint(), directoryRoleId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateDirectoryRoleAsync(String directoryRoleId, MicrosoftGraphDirectoryRoleInner body) {
        return this.updateDirectoryRoleWithResponseAsync(directoryRoleId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateDirectoryRole(String directoryRoleId, MicrosoftGraphDirectoryRoleInner body) {
        this.updateDirectoryRoleAsync(directoryRoleId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateDirectoryRoleWithResponse(String directoryRoleId, MicrosoftGraphDirectoryRoleInner body, Context context) {
        return (Response)this.updateDirectoryRoleWithResponseAsync(directoryRoleId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDirectoryRoleWithResponseAsync(String directoryRoleId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteDirectoryRole(this.client.getEndpoint(), directoryRoleId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteDirectoryRoleWithResponseAsync(String directoryRoleId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteDirectoryRole(this.client.getEndpoint(), directoryRoleId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDirectoryRoleAsync(String directoryRoleId, String ifMatch) {
        return this.deleteDirectoryRoleWithResponseAsync(directoryRoleId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDirectoryRoleAsync(String directoryRoleId) {
        String ifMatch = null;
        return this.deleteDirectoryRoleWithResponseAsync(directoryRoleId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDirectoryRole(String directoryRoleId) {
        String ifMatch = null;
        this.deleteDirectoryRoleAsync(directoryRoleId, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDirectoryRoleWithResponse(String directoryRoleId, String ifMatch, Context context) {
        return (Response)this.deleteDirectoryRoleWithResponseAsync(directoryRoleId, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryRoleInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryRole)res.getValue()).value(), ((CollectionOfDirectoryRole)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryRoleInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryRole)res.getValue()).value(), ((CollectionOfDirectoryRole)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface DirectoryRolesDirectoryRolesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/directoryRoles")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryRole>> listDirectoryRole(@HostParam(value="$host") String var1, @QueryParam(value="$top") Integer var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$search") String var4, @QueryParam(value="$filter") String var5, @QueryParam(value="$count") Boolean var6, @QueryParam(value="$orderby") String var7, @QueryParam(value="$select") String var8, @QueryParam(value="$expand") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directoryRoles")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryRoleInner>> createDirectoryRole(@HostParam(value="$host") String var1, @BodyParam(value="application/json") MicrosoftGraphDirectoryRoleInner var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/directoryRoles/{directoryRole-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryRoleInner>> getDirectoryRole(@HostParam(value="$host") String var1, @PathParam(value="directoryRole-id") String var2, @QueryParam(value="$select") String var3, @QueryParam(value="$expand") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/directoryRoles/{directoryRole-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateDirectoryRole(@HostParam(value="$host") String var1, @PathParam(value="directoryRole-id") String var2, @BodyParam(value="application/json") MicrosoftGraphDirectoryRoleInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/directoryRoles/{directoryRole-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteDirectoryRole(@HostParam(value="$host") String var1, @PathParam(value="directoryRole-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryRole>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

