/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsAddPasswordRequestBodyInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphApplicationInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphKeyCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPasswordCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphWebApplication;
import com.azure.resourcemanager.authorization.implementation.CertificateCredentialImpl;
import com.azure.resourcemanager.authorization.implementation.HasCredential;
import com.azure.resourcemanager.authorization.implementation.PasswordCredentialImpl;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryApplication;
import com.azure.resourcemanager.authorization.models.ApplicationAccountType;
import com.azure.resourcemanager.authorization.models.CertificateCredential;
import com.azure.resourcemanager.authorization.models.PasswordCredential;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ActiveDirectoryApplicationImpl
extends CreatableUpdatableImpl<ActiveDirectoryApplication, MicrosoftGraphApplicationInner, ActiveDirectoryApplicationImpl>
implements ActiveDirectoryApplication,
ActiveDirectoryApplication.Definition,
ActiveDirectoryApplication.Update,
HasCredential<ActiveDirectoryApplicationImpl> {
    private AuthorizationManager manager;
    private final Map<String, PasswordCredential> cachedPasswordCredentials;
    private final Map<String, CertificateCredential> cachedCertificateCredentials;
    private final List<PasswordCredentialImpl<?>> passwordCredentialToCreate;
    private final List<CertificateCredentialImpl<?>> certificateCredentialToCreate;

    ActiveDirectoryApplicationImpl(MicrosoftGraphApplicationInner innerObject, AuthorizationManager manager) {
        super(innerObject.displayName(), (Object)innerObject);
        this.manager = manager;
        this.cachedPasswordCredentials = new HashMap<String, PasswordCredential>();
        this.cachedCertificateCredentials = new HashMap<String, CertificateCredential>();
        this.passwordCredentialToCreate = new ArrayList();
        this.certificateCredentialToCreate = new ArrayList();
        this.refreshCredentials(innerObject);
    }

    public boolean isInCreateMode() {
        return this.id() == null;
    }

    public Mono<ActiveDirectoryApplication> createResourceAsync() {
        return this.manager.serviceClient().getApplicationsApplications().createApplicationAsync((MicrosoftGraphApplicationInner)this.innerModel()).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).flatMap(app -> this.submitCredentialAsync().doOnComplete(this::postRequest).then(this.refreshAsync()));
    }

    public Mono<ActiveDirectoryApplication> updateResourceAsync() {
        return this.manager.serviceClient().getApplicationsApplications().updateApplicationAsync(this.id(), (MicrosoftGraphApplicationInner)this.innerModel()).then(this.submitCredentialAsync().doOnComplete(this::postRequest).then(this.refreshAsync()));
    }

    void refreshCredentials(MicrosoftGraphApplicationInner inner) {
        this.cachedCertificateCredentials.clear();
        this.cachedPasswordCredentials.clear();
        if (inner.keyCredentials() != null) {
            inner.keyCredentials().forEach(keyCredentialInner -> {
                CertificateCredentialImpl certificateCredential = new CertificateCredentialImpl((MicrosoftGraphKeyCredentialInner)keyCredentialInner);
                this.cachedCertificateCredentials.put(certificateCredential.name(), certificateCredential);
            });
        }
        if (inner.passwordCredentials() != null) {
            inner.passwordCredentials().forEach(passwordCredentialInner -> {
                PasswordCredentialImpl passwordCredential = new PasswordCredentialImpl((MicrosoftGraphPasswordCredentialInner)passwordCredentialInner);
                this.cachedPasswordCredentials.put(passwordCredential.name(), passwordCredential);
            });
        }
    }

    Flux<?> submitCredentialAsync() {
        return Flux.defer(() -> Flux.fromIterable(this.passwordCredentialToCreate).flatMap(passwordCredential -> this.manager().serviceClient().getApplications().addPasswordAsync(this.id(), new ApplicationsAddPasswordRequestBodyInner().withPasswordCredential((MicrosoftGraphPasswordCredentialInner)passwordCredential.innerModel())).doOnNext(arg_0 -> ((PasswordCredentialImpl)passwordCredential).setInner(arg_0))));
    }

    void postRequest() {
        this.passwordCredentialToCreate.forEach(passwordCredential -> passwordCredential.exportAuthFile(this));
        this.passwordCredentialToCreate.forEach(PasswordCredentialImpl::consumeSecret);
        this.passwordCredentialToCreate.clear();
        this.certificateCredentialToCreate.forEach(certificateCredential -> certificateCredential.exportAuthFile(this));
        this.certificateCredentialToCreate.clear();
    }

    public Mono<ActiveDirectoryApplication> refreshAsync() {
        return this.getInnerAsync().map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    @Override
    public String applicationId() {
        return ((MicrosoftGraphApplicationInner)this.innerModel()).appId();
    }

    @Override
    public boolean availableToOtherTenants() {
        return this.accountType() != ApplicationAccountType.AZURE_AD_MY_ORG;
    }

    @Override
    public ApplicationAccountType accountType() {
        return ApplicationAccountType.fromString(((MicrosoftGraphApplicationInner)this.innerModel()).signInAudience());
    }

    @Override
    public Set<String> identifierUris() {
        if (((MicrosoftGraphApplicationInner)this.innerModel()).identifierUris() == null) {
            return null;
        }
        return new HashSet<String>(((MicrosoftGraphApplicationInner)this.innerModel()).identifierUris());
    }

    @Override
    public Set<String> replyUrls() {
        if (((MicrosoftGraphApplicationInner)this.innerModel()).web() == null || ((MicrosoftGraphApplicationInner)this.innerModel()).web().redirectUris() == null) {
            return null;
        }
        return new HashSet<String>(((MicrosoftGraphApplicationInner)this.innerModel()).web().redirectUris());
    }

    @Override
    public URL signOnUrl() {
        try {
            return new URL(((MicrosoftGraphApplicationInner)this.innerModel()).web().homePageUrl());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public Map<String, PasswordCredential> passwordCredentials() {
        if (this.cachedPasswordCredentials == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.cachedPasswordCredentials);
    }

    @Override
    public Map<String, CertificateCredential> certificateCredentials() {
        if (this.cachedCertificateCredentials == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.cachedCertificateCredentials);
    }

    protected Mono<MicrosoftGraphApplicationInner> getInnerAsync() {
        return this.manager.serviceClient().getApplicationsApplications().getApplicationAsync(this.id()).doOnSuccess(this::refreshCredentials);
    }

    @Override
    public ActiveDirectoryApplicationImpl withSignOnUrl(String signOnUrl) {
        if (((MicrosoftGraphApplicationInner)this.innerModel()).web() == null) {
            ((MicrosoftGraphApplicationInner)this.innerModel()).withWeb(new MicrosoftGraphWebApplication());
        }
        ((MicrosoftGraphApplicationInner)this.innerModel()).web().withHomePageUrl(signOnUrl);
        return this;
    }

    @Override
    public ActiveDirectoryApplicationImpl withReplyUrl(String replyUrl) {
        if (((MicrosoftGraphApplicationInner)this.innerModel()).web() == null) {
            ((MicrosoftGraphApplicationInner)this.innerModel()).withWeb(new MicrosoftGraphWebApplication());
        }
        if (((MicrosoftGraphApplicationInner)this.innerModel()).web().redirectUris() == null) {
            ((MicrosoftGraphApplicationInner)this.innerModel()).web().withRedirectUris(new ArrayList<String>());
        }
        ((MicrosoftGraphApplicationInner)this.innerModel()).web().redirectUris().add(replyUrl);
        return this;
    }

    @Override
    public ActiveDirectoryApplicationImpl withoutReplyUrl(String replyUrl) {
        if (((MicrosoftGraphApplicationInner)this.innerModel()).web() != null && ((MicrosoftGraphApplicationInner)this.innerModel()).web().redirectUris() != null) {
            ((MicrosoftGraphApplicationInner)this.innerModel()).web().redirectUris().remove(replyUrl);
        }
        return this;
    }

    @Override
    public ActiveDirectoryApplicationImpl withIdentifierUrl(String identifierUrl) {
        if (((MicrosoftGraphApplicationInner)this.innerModel()).identifierUris() == null) {
            ((MicrosoftGraphApplicationInner)this.innerModel()).withIdentifierUris(new ArrayList<String>());
        }
        ((MicrosoftGraphApplicationInner)this.innerModel()).identifierUris().add(identifierUrl);
        return this;
    }

    @Override
    public ActiveDirectoryApplication.Update withoutIdentifierUrl(String identifierUrl) {
        if (((MicrosoftGraphApplicationInner)this.innerModel()).identifierUris() != null) {
            ((MicrosoftGraphApplicationInner)this.innerModel()).identifierUris().remove(identifierUrl);
        }
        return this;
    }

    public CertificateCredentialImpl<ActiveDirectoryApplicationImpl> defineCertificateCredential(String name) {
        return new CertificateCredentialImpl<ActiveDirectoryApplicationImpl>(name, this);
    }

    public PasswordCredentialImpl<ActiveDirectoryApplicationImpl> definePasswordCredential(String name) {
        return new PasswordCredentialImpl<ActiveDirectoryApplicationImpl>(name, this);
    }

    @Override
    public ActiveDirectoryApplicationImpl withoutCredential(String name) {
        if (this.cachedPasswordCredentials.containsKey(name) && ((MicrosoftGraphApplicationInner)this.innerModel()).passwordCredentials() != null) {
            ((MicrosoftGraphApplicationInner)this.innerModel()).passwordCredentials().remove(this.cachedPasswordCredentials.get(name).innerModel());
        } else if (this.cachedCertificateCredentials.containsKey(name) && ((MicrosoftGraphApplicationInner)this.innerModel()).keyCredentials() != null) {
            ((MicrosoftGraphApplicationInner)this.innerModel()).keyCredentials().remove(this.cachedCertificateCredentials.get(name).innerModel());
        }
        return this;
    }

    @Override
    public ActiveDirectoryApplicationImpl withCertificateCredential(CertificateCredentialImpl<?> credential) {
        this.certificateCredentialToCreate.add(credential);
        if (((MicrosoftGraphApplicationInner)this.innerModel()).keyCredentials() == null) {
            ((MicrosoftGraphApplicationInner)this.innerModel()).withKeyCredentials(new ArrayList<MicrosoftGraphKeyCredentialInner>());
        }
        ((MicrosoftGraphApplicationInner)this.innerModel()).keyCredentials().add((MicrosoftGraphKeyCredentialInner)credential.innerModel());
        return this;
    }

    @Override
    public ActiveDirectoryApplicationImpl withPasswordCredential(PasswordCredentialImpl<?> credential) {
        this.passwordCredentialToCreate.add(credential);
        return this;
    }

    @Override
    public ActiveDirectoryApplicationImpl withAvailableToOtherTenants(boolean availableToOtherTenants) {
        return availableToOtherTenants ? this.withAccountType(ApplicationAccountType.AZURE_AD_MULTIPLE_ORGS) : this.withAccountType(ApplicationAccountType.AZURE_AD_MY_ORG);
    }

    @Override
    public ActiveDirectoryApplicationImpl withAccountType(ApplicationAccountType accountType) {
        return this.withAccountType(accountType.toString());
    }

    @Override
    public ActiveDirectoryApplicationImpl withAccountType(String accountType) {
        ((MicrosoftGraphApplicationInner)this.innerModel()).withSignInAudience(accountType);
        return this;
    }

    public String id() {
        return ((MicrosoftGraphApplicationInner)this.innerModel()).id();
    }

    public AuthorizationManager manager() {
        return this.manager;
    }
}

