/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Target;
import org.snmp4j.util.PDUFactory;

public class DefaultPDUFactory
implements PDUFactory {
    private int pduType = -96;

    public DefaultPDUFactory() {
    }

    public DefaultPDUFactory(int pduType) {
        this.setPduType(pduType);
    }

    public void setPduType(int pduType) {
        this.pduType = pduType;
    }

    public int getPduType() {
        return this.pduType;
    }

    @Override
    public PDU createPDU(Target target) {
        return DefaultPDUFactory.createPDU(target, this.pduType);
    }

    public static PDU createPDU(Target target, int pduType) {
        PDU request = DefaultPDUFactory.createPDU(target.getVersion());
        request.setType(pduType);
        return request;
    }

    public static PDU createPDU(int targetVersion) {
        PDU request;
        switch (targetVersion) {
            case 3: {
                request = new ScopedPDU();
                break;
            }
            case 0: {
                request = new PDUv1();
                break;
            }
            default: {
                request = new PDU();
            }
        }
        return request;
    }
}

