/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import org.snmp4j.CertifiedIdentity;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageException;
import org.snmp4j.MutablePDU;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.TransportStateReference;
import org.snmp4j.UserTarget;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.asn1.BEROutputStream;
import org.snmp4j.event.AuthenticationFailureEvent;
import org.snmp4j.event.AuthenticationFailureListener;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.CounterListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.MutableStateReference;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.PduHandleCallback;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.security.SecurityLevel;
import org.snmp4j.security.TsmSecurityStateReference;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.UnsupportedAddressClassException;

public class MessageDispatcherImpl
implements MessageDispatcher {
    private static final LogAdapter logger = LogFactory.getLogger(MessageDispatcherImpl.class);
    private List<MessageProcessingModel> mpm = new ArrayList<MessageProcessingModel>(3);
    private Map<Class<? extends Address>, List<TransportMapping>> transportMappings = new Hashtable<Class<? extends Address>, List<TransportMapping>>(5);
    private int nextTransactionID = new Random().nextInt(0x7FFFFFFD) + 1;
    private transient List<CommandResponder> commandResponderListeners;
    private transient List<CounterListener> counterListeners;
    private transient List<AuthenticationFailureListener> authenticationFailureListeners;
    private boolean checkOutgoingMsg = true;

    @Override
    public synchronized void addMessageProcessingModel(MessageProcessingModel model) {
        while (this.mpm.size() <= model.getID()) {
            this.mpm.add(null);
        }
        if (this.mpm.get(model.getID()) == null) {
            this.mpm.set(model.getID(), model);
        }
    }

    @Override
    public synchronized void removeMessageProcessingModel(MessageProcessingModel model) {
        this.mpm.set(model.getID(), null);
    }

    @Override
    public synchronized void addTransportMapping(TransportMapping transport) {
        List<TransportMapping> transports = this.transportMappings.get(transport.getSupportedAddressClass());
        if (transports == null) {
            transports = new LinkedList<TransportMapping>();
            this.transportMappings.put(transport.getSupportedAddressClass(), transports);
        }
        transports.add(transport);
    }

    @Override
    public TransportMapping removeTransportMapping(TransportMapping transport) {
        List<TransportMapping> tm = this.transportMappings.remove(transport.getSupportedAddressClass());
        if (tm != null && tm.remove(transport)) {
            return transport;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<TransportMapping> getTransportMappings() {
        ArrayList<TransportMapping> l = new ArrayList<TransportMapping>(this.transportMappings.size());
        Map<Class<? extends Address>, List<TransportMapping>> map = this.transportMappings;
        synchronized (map) {
            for (List<TransportMapping> tm : this.transportMappings.values()) {
                l.addAll(tm);
            }
        }
        return l;
    }

    @Override
    public synchronized int getNextRequestID() {
        int nextID;
        if ((nextID = this.nextTransactionID++) <= 0) {
            nextID = 1;
            this.nextTransactionID = 2;
        }
        return nextID;
    }

    protected PduHandle createPduHandle() {
        return new PduHandle(this.getNextRequestID());
    }

    protected void sendMessage(TransportMapping transport, Address destAddress, byte[] message, TransportStateReference tmStateReference) throws IOException {
        if (destAddress instanceof GenericAddress) {
            destAddress = ((GenericAddress)destAddress).getAddress();
        }
        if (transport == null) {
            String txt = "No transport mapping for address class: " + destAddress.getClass().getName() + "=" + destAddress;
            logger.error((Serializable)((Object)txt));
            throw new IOException(txt);
        }
        transport.sendMessage(destAddress, message, tmStateReference);
    }

    @Override
    public TransportMapping getTransport(Address destAddress) {
        Class<?> addressClass = destAddress.getClass();
        do {
            List<TransportMapping> l;
            if ((l = this.transportMappings.get(addressClass)) == null || l.size() <= 0) continue;
            return l.get(0);
        } while ((addressClass = addressClass.getSuperclass()) != null);
        return null;
    }

    protected void dispatchMessage(TransportMapping sourceTransport, MessageProcessingModel mp, Address incomingAddress, BERInputStream wholeMessage, TransportStateReference tmStateReference) throws IOException {
        MutablePDU pdu = new MutablePDU();
        Integer32 messageProcessingModel = new Integer32();
        Integer32 securityModel = new Integer32();
        OctetString securityName = new OctetString();
        Integer32 securityLevel = new Integer32();
        PduHandle handle = this.createPduHandle();
        Integer32 maxSizeRespPDU = new Integer32(sourceTransport.getMaxInboundMessageSize());
        StatusInformation statusInfo = new StatusInformation();
        MutableStateReference mutableStateReference = new MutableStateReference();
        StateReference stateReference = new StateReference();
        stateReference.setTransportMapping(sourceTransport);
        stateReference.setAddress(incomingAddress);
        mutableStateReference.setStateReference(stateReference);
        int status = mp.prepareDataElements(this, incomingAddress, wholeMessage, tmStateReference, messageProcessingModel, securityModel, securityName, securityLevel, pdu, handle, maxSizeRespPDU, statusInfo, mutableStateReference);
        if (mutableStateReference.getStateReference() != null) {
            mutableStateReference.getStateReference().setTransportMapping(sourceTransport);
        }
        if (status == 0) {
            CommandResponderEvent e = new CommandResponderEvent(this, sourceTransport, incomingAddress, messageProcessingModel.getValue(), securityModel.getValue(), securityName.getValue(), securityLevel.getValue(), handle, pdu.getPdu(), maxSizeRespPDU.getValue(), mutableStateReference.getStateReference());
            this.fireProcessPdu(e);
        } else {
            switch (status) {
                case -1414: 
                case -1412: 
                case -1402: 
                case 1403: 
                case 1404: 
                case 1407: 
                case 1408: 
                case 1410: 
                case 1411: 
                case 1412: 
                case 1603: {
                    AuthenticationFailureEvent event = new AuthenticationFailureEvent(this, incomingAddress, sourceTransport, status, wholeMessage);
                    this.fireAuthenticationFailure(event);
                    break;
                }
            }
            logger.warn((Serializable)((Object)("statusInfo=" + statusInfo + ", status=" + status)));
        }
    }

    @Override
    public void processMessage(TransportMapping sourceTransport, Address incomingAddress, ByteBuffer wholeMessage, TransportStateReference tmStateReference) {
        this.processMessage(sourceTransport, incomingAddress, new BERInputStream(wholeMessage), tmStateReference);
    }

    public void processMessage(TransportMapping sourceTransport, Address incomingAddress, BERInputStream wholeMessage, TransportStateReference tmStateReference) {
        block10: {
            this.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpInPkts));
            if (!wholeMessage.markSupported()) {
                String txt = "Message stream must support marks";
                logger.error((Serializable)((Object)txt));
                throw new IllegalArgumentException(txt);
            }
            try {
                wholeMessage.mark(16);
                BER.MutableByte type = new BER.MutableByte();
                BER.decodeHeader(wholeMessage, type, false);
                if (type.getValue() != 48) {
                    logger.error((Serializable)((Object)"ASN.1 parse error (message is not a sequence)"));
                    CounterEvent event = new CounterEvent(this, SnmpConstants.snmpInASNParseErrs);
                    this.fireIncrementCounter(event);
                }
                Integer32 version = new Integer32();
                version.decodeBER(wholeMessage);
                MessageProcessingModel mp = this.getMessageProcessingModel(version.getValue());
                if (mp == null) {
                    logger.warn((Serializable)((Object)("SNMP version " + version + " is not supported")));
                    CounterEvent event = new CounterEvent(this, SnmpConstants.snmpInBadVersions);
                    this.fireIncrementCounter(event);
                } else {
                    wholeMessage.reset();
                    this.dispatchMessage(sourceTransport, mp, incomingAddress, wholeMessage, tmStateReference);
                }
            }
            catch (IOException iox) {
                iox.printStackTrace();
                logger.warn(iox);
                CounterEvent event = new CounterEvent(this, SnmpConstants.snmpInvalidMsgs);
                this.fireIncrementCounter(event);
            }
            catch (Exception ex) {
                logger.error(ex);
                if (logger.isDebugEnabled()) {
                    ex.printStackTrace();
                }
                if (SNMP4JSettings.isFowardRuntimeExceptions()) {
                    throw new RuntimeException(ex);
                }
            }
            catch (OutOfMemoryError oex) {
                logger.error(oex);
                if (!SNMP4JSettings.isFowardRuntimeExceptions()) break block10;
                throw oex;
            }
        }
    }

    @Override
    public PduHandle sendPdu(Target target, PDU pdu, boolean expectResponse) throws MessageException {
        return this.sendPdu(null, target, pdu, expectResponse);
    }

    @Override
    public PduHandle sendPdu(TransportMapping transport, Target target, PDU pdu, boolean expectResponse, PduHandleCallback<PDU> pduHandleCallback) throws MessageException {
        int messageProcessingModel = target.getVersion();
        Address transportAddress = target.getAddress();
        int securityModel = target.getSecurityModel();
        int securityLevel = target.getSecurityLevel();
        try {
            byte[] securityName = target.getSecurityName().getValue();
            MessageProcessingModel mp = this.getMessageProcessingModel(messageProcessingModel);
            if (mp == null) {
                throw new MessageException("Unsupported message processing model: " + messageProcessingModel);
            }
            if (!mp.isProtocolVersionSupported(messageProcessingModel)) {
                throw new MessageException("SNMP version " + messageProcessingModel + " is not supported " + "by message processing model " + messageProcessingModel);
            }
            if (transport == null) {
                transport = this.getTransport(transportAddress);
            }
            if (transport == null) {
                throw new UnsupportedAddressClassException("Unsupported address class (transport mapping): " + transportAddress.getClass().getName(), transportAddress.getClass());
            }
            if (pdu.isConfirmedPdu()) {
                MessageDispatcherImpl.checkListening4ConfirmedPDU(pdu, target.getAddress(), transport);
            }
            this.checkOutgoingMsg(transportAddress, messageProcessingModel, pdu);
            Integer32 reqID = pdu.getRequestID();
            PduHandle pduHandle = reqID == null || reqID.getValue() == 0 && pdu.getType() != -94 ? this.createPduHandle() : new PduHandle(pdu.getRequestID().getValue());
            if (pdu.getType() != -92) {
                pdu.setRequestID(new Integer32(pduHandle.getTransactionID()));
            }
            GenericAddress destAddress = new GenericAddress();
            CertifiedIdentity certifiedIdentity = null;
            if (target instanceof CertifiedIdentity) {
                certifiedIdentity = (CertifiedIdentity)((Object)target);
            }
            TransportStateReference tmStateReference = new TransportStateReference(transport, transportAddress, new OctetString(securityName), SecurityLevel.get(securityLevel), SecurityLevel.undefined, false, null, certifiedIdentity);
            this.configureAuthoritativeEngineID(target, mp);
            BEROutputStream outgoingMessage = new BEROutputStream();
            int status = mp.prepareOutgoingMessage(transportAddress, transport.getMaxInboundMessageSize(), messageProcessingModel, securityModel, securityName, securityLevel, pdu, expectResponse, pduHandle, destAddress, outgoingMessage, tmStateReference);
            if (status == 0) {
                if (pduHandleCallback != null) {
                    pduHandleCallback.pduHandleAssigned(pduHandle, pdu);
                }
            } else {
                throw new MessageException("Message processing model " + mp.getID() + " returned error: " + SnmpConstants.mpErrorMessage(status));
            }
            byte[] messageBytes = outgoingMessage.getBuffer().array();
            this.sendMessage(transport, transportAddress, messageBytes, tmStateReference);
            return pduHandle;
        }
        catch (IndexOutOfBoundsException iobex) {
            throw new MessageException("Unsupported message processing model: " + messageProcessingModel);
        }
        catch (MessageException mex) {
            if (logger.isDebugEnabled()) {
                mex.printStackTrace();
            }
            throw mex;
        }
        catch (IOException iox) {
            if (logger.isDebugEnabled()) {
                iox.printStackTrace();
            }
            throw new MessageException(iox.getMessage());
        }
    }

    protected void configureAuthoritativeEngineID(Target target, MessageProcessingModel mp) {
        UserTarget userTarget;
        if (target instanceof UserTarget && mp instanceof MPv3 && (userTarget = (UserTarget)target).getAuthoritativeEngineID() != null && userTarget.getAuthoritativeEngineID().length > 0) {
            ((MPv3)mp).addEngineID(target.getAddress(), new OctetString(userTarget.getAuthoritativeEngineID()));
        }
    }

    private static void checkListening4ConfirmedPDU(PDU pdu, Address target, TransportMapping transport) {
        if (transport != null && !transport.isListening()) {
            logger.warn((Serializable)((Object)("Sending confirmed PDU " + pdu + " to target " + target + " although transport mapping " + transport + " is not listening for a response")));
        }
    }

    protected void checkOutgoingMsg(Address transportAddress, int messageProcessingModel, PDU pdu) throws MessageException {
        if (this.checkOutgoingMsg && messageProcessingModel == 0 && pdu.getType() == -91) {
            logger.warn((Serializable)((Object)("Converting GETBULK PDU to GETNEXT for SNMPv1 target: " + transportAddress)));
            pdu.setType(-95);
            if (!(pdu instanceof PDUv1)) {
                pdu.setMaxRepetitions(0);
            }
        }
    }

    @Override
    public int returnResponsePdu(int messageProcessingModel, int securityModel, byte[] securityName, int securityLevel, PDU pdu, int maxSizeResponseScopedPDU, StateReference stateReference, StatusInformation statusInformation) throws MessageException {
        try {
            MessageProcessingModel mp = this.getMessageProcessingModel(messageProcessingModel);
            if (mp == null) {
                throw new MessageException("Unsupported message processing model: " + messageProcessingModel);
            }
            TransportMapping transport = stateReference.getTransportMapping();
            if (transport == null) {
                transport = this.getTransport(stateReference.getAddress());
            }
            if (transport == null) {
                throw new MessageException("Unsupported address class (transport mapping): " + stateReference.getAddress().getClass().getName());
            }
            BEROutputStream outgoingMessage = new BEROutputStream();
            int status = mp.prepareResponseMessage(messageProcessingModel, transport.getMaxInboundMessageSize(), securityModel, securityName, securityLevel, pdu, maxSizeResponseScopedPDU, stateReference, statusInformation, outgoingMessage);
            if (status == 0) {
                TransportStateReference tmStateReference = null;
                if (stateReference.getSecurityStateReference() instanceof TsmSecurityStateReference) {
                    tmStateReference = ((TsmSecurityStateReference)stateReference.getSecurityStateReference()).getTmStateReference();
                }
                this.sendMessage(transport, stateReference.getAddress(), outgoingMessage.getBuffer().array(), tmStateReference);
            }
            return status;
        }
        catch (ArrayIndexOutOfBoundsException aex) {
            throw new MessageException("Unsupported message processing model: " + messageProcessingModel);
        }
        catch (IOException iox) {
            throw new MessageException(iox.getMessage());
        }
    }

    @Override
    public void releaseStateReference(int messageProcessingModel, PduHandle pduHandle) {
        MessageProcessingModel mp = this.getMessageProcessingModel(messageProcessingModel);
        if (mp == null) {
            throw new IllegalArgumentException("Unsupported message processing model: " + messageProcessingModel);
        }
        mp.releaseStateReference(pduHandle);
    }

    @Override
    public synchronized void removeCommandResponder(CommandResponder l) {
        if (this.commandResponderListeners != null && this.commandResponderListeners.contains(l)) {
            this.commandResponderListeners.remove(l);
        }
    }

    @Override
    public synchronized void addCommandResponder(CommandResponder l) {
        if (this.commandResponderListeners == null) {
            this.commandResponderListeners = new Vector<CommandResponder>(2);
        }
        if (!this.commandResponderListeners.contains(l)) {
            this.commandResponderListeners.add(l);
        }
    }

    protected void fireProcessPdu(CommandResponderEvent e) {
        if (this.commandResponderListeners != null) {
            List<CommandResponder> listeners = this.commandResponderListeners;
            for (CommandResponder listener : listeners) {
                listener.processPdu(e);
                if (!e.isProcessed()) continue;
                return;
            }
        }
    }

    @Override
    public MessageProcessingModel getMessageProcessingModel(int messageProcessingModel) {
        try {
            return this.mpm.get(messageProcessingModel);
        }
        catch (IndexOutOfBoundsException iobex) {
            return null;
        }
    }

    public synchronized void removeCounterListener(CounterListener counterListener) {
        if (this.counterListeners != null && this.counterListeners.contains(counterListener)) {
            this.counterListeners.remove(counterListener);
        }
    }

    public synchronized void addCounterListener(CounterListener counterListener) {
        if (this.counterListeners == null) {
            this.counterListeners = new Vector<CounterListener>(2);
        }
        if (!this.counterListeners.contains(counterListener)) {
            this.counterListeners.add(counterListener);
        }
    }

    protected void fireIncrementCounter(CounterEvent event) {
        if (this.counterListeners != null) {
            for (CounterListener cl : this.counterListeners) {
                cl.incrementCounter(event);
            }
        }
    }

    public void setCheckOutgoingMsg(boolean checkOutgoingMsg) {
        this.checkOutgoingMsg = checkOutgoingMsg;
    }

    public boolean isCheckOutgoingMsg() {
        return this.checkOutgoingMsg;
    }

    public synchronized void addAuthenticationFailureListener(AuthenticationFailureListener l) {
        if (this.authenticationFailureListeners == null) {
            this.authenticationFailureListeners = new Vector<AuthenticationFailureListener>(2);
        }
        if (!this.authenticationFailureListeners.contains(l)) {
            this.authenticationFailureListeners.add(l);
        }
    }

    public synchronized void removeAuthenticationFailureListener(AuthenticationFailureListener l) {
        if (this.authenticationFailureListeners != null && this.authenticationFailureListeners.contains(l)) {
            this.authenticationFailureListeners.remove(l);
        }
    }

    protected void fireAuthenticationFailure(AuthenticationFailureEvent event) {
        if (this.authenticationFailureListeners != null) {
            List<AuthenticationFailureListener> listeners = this.authenticationFailureListeners;
            for (AuthenticationFailureListener listener : listeners) {
                listener.authenticationFailure(event);
            }
        }
    }

    @Override
    public PduHandle sendPdu(TransportMapping transportMapping, Target target, PDU pdu, boolean expectResponse) throws MessageException {
        return this.sendPdu(transportMapping, target, pdu, expectResponse, null);
    }
}

