/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import com.ahsay.afc.SystemInfo;
import com.ahsay.afc.util.FileUtil;
import com.ahsay.afc.util.StringUtil;
import java.io.File;

public class SnappyUtil {
    private static final String JAVA_LIB_PATH_PROPERTY_KEY = "java.library.path";
    private static final String SNAPPY_DIR = "snappy";
    private static boolean bLibPathInitialized = false;
    private static final Object LIB_PATH_INITIALIZATION_LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initLibPath() {
        Object object = LIB_PATH_INITIALIZATION_LOCK;
        synchronized (object) {
            if (bLibPathInitialized) {
                return;
            }
            try {
                String sOSArchLibPath;
                String sJavaLibPathProperty = System.getProperty(JAVA_LIB_PATH_PROPERTY_KEY);
                String sLibraryName = SystemInfo.getMappedLibraryName((String)"snappyjava");
                if (sJavaLibPathProperty != null && !"".equals(sJavaLibPathProperty)) {
                    String[] asLibPath;
                    for (String sLibPath : asLibPath = StringUtil.split((String)sJavaLibPathProperty, (String)File.pathSeparator)) {
                        if (!FileUtil.exists((File)new File(sLibPath, sLibraryName))) continue;
                        System.setProperty("org.xerial.snappy.lib.path", sLibPath);
                        System.setProperty("org.xerial.snappy.lib.name", sLibraryName);
                        return;
                    }
                }
                if (FileUtil.exists((File)new File(sOSArchLibPath = SystemInfo.getOSArchLibPath(), sLibraryName))) {
                    System.setProperty("org.xerial.snappy.lib.path", sOSArchLibPath);
                    System.setProperty("org.xerial.snappy.lib.name", sLibraryName);
                }
            }
            finally {
                bLibPathInitialized = true;
            }
        }
    }
}

