/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.IOException;
import java.io.OutputStream;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyCodec;
import org.xerial.snappy.SnappyUtil;
import org.xerial.snappy.buffer.BufferAllocator;
import org.xerial.snappy.buffer.BufferAllocatorFactory;
import org.xerial.snappy.buffer.CachedBufferAllocator;

public class SnappyOutputStream
extends OutputStream {
    static final int MIN_BLOCK_SIZE = 1024;
    static final int DEFAULT_BLOCK_SIZE = 32768;
    static final int DEFAULT_MAX_COMPRESSED_LENGTH;
    protected final OutputStream out;
    private final int blockSize;
    private final BufferAllocator inputBufferAllocator;
    private final BufferAllocator outputBufferAllocator;
    protected byte[] inputBuffer;
    protected byte[] outputBuffer;
    private int inputCursor = 0;
    private int outputCursor = 0;
    private boolean headerWritten;
    private boolean closed;

    public SnappyOutputStream(OutputStream out) {
        this(out, 32768);
    }

    public SnappyOutputStream(OutputStream out, int blockSize) {
        this(out, blockSize, CachedBufferAllocator.getBufferAllocatorFactory());
    }

    public SnappyOutputStream(OutputStream out, int blockSize, BufferAllocatorFactory bufferAllocatorFactory) {
        this.out = out;
        this.blockSize = Math.max(1024, blockSize);
        int inputSize = blockSize;
        int outputSize = SnappyCodec.HEADER_SIZE + 4 + Snappy.maxCompressedLength(blockSize);
        this.inputBufferAllocator = bufferAllocatorFactory.getBufferAllocator(inputSize);
        this.outputBufferAllocator = bufferAllocatorFactory.getBufferAllocator(outputSize);
        this.inputBuffer = this.inputBufferAllocator.allocate(inputSize);
        this.outputBuffer = this.outputBufferAllocator.allocate(outputSize);
    }

    @Override
    public void write(byte[] b, int byteOffset, int byteLength) throws IOException {
        int readLen;
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        for (int cursor = 0; cursor < byteLength; cursor += readLen) {
            readLen = Math.min(byteLength - cursor, this.blockSize - this.inputCursor);
            if (readLen > 0) {
                System.arraycopy(b, byteOffset + cursor, this.inputBuffer, this.inputCursor, readLen);
                this.inputCursor += readLen;
            }
            if (this.inputCursor < this.blockSize) {
                return;
            }
            this.compressInput();
        }
    }

    public void write(long[] d, int off, int len) throws IOException {
        this.rawWrite(d, off * 8, len * 8);
    }

    public void write(double[] f, int off, int len) throws IOException {
        this.rawWrite(f, off * 8, len * 8);
    }

    public void write(float[] f, int off, int len) throws IOException {
        this.rawWrite(f, off * 4, len * 4);
    }

    public void write(int[] f, int off, int len) throws IOException {
        this.rawWrite(f, off * 4, len * 4);
    }

    public void write(short[] f, int off, int len) throws IOException {
        this.rawWrite(f, off * 2, len * 2);
    }

    public void write(long[] d) throws IOException {
        this.write(d, 0, d.length);
    }

    public void write(double[] f) throws IOException {
        this.write(f, 0, f.length);
    }

    public void write(float[] f) throws IOException {
        this.write(f, 0, f.length);
    }

    public void write(int[] f) throws IOException {
        this.write(f, 0, f.length);
    }

    public void write(short[] f) throws IOException {
        this.write(f, 0, f.length);
    }

    private boolean hasSufficientOutputBufferFor(int inputSize) {
        int maxCompressedSize = Snappy.maxCompressedLength(inputSize);
        return maxCompressedSize < this.outputBuffer.length - this.outputCursor - 4;
    }

    public void rawWrite(Object array, int byteOffset, int byteLength) throws IOException {
        int readLen;
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        for (int cursor = 0; cursor < byteLength; cursor += readLen) {
            readLen = Math.min(byteLength - cursor, this.blockSize - this.inputCursor);
            if (readLen > 0) {
                Snappy.arrayCopy(array, byteOffset + cursor, readLen, this.inputBuffer, this.inputCursor);
                this.inputCursor += readLen;
            }
            if (this.inputCursor < this.blockSize) {
                return;
            }
            this.compressInput();
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.inputCursor >= this.inputBuffer.length) {
            this.compressInput();
        }
        this.inputBuffer[this.inputCursor++] = (byte)b;
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        this.compressInput();
        this.dumpOutput();
        this.out.flush();
    }

    static void writeInt(byte[] dst, int offset, int v) {
        dst[offset] = (byte)(v >> 24 & 0xFF);
        dst[offset + 1] = (byte)(v >> 16 & 0xFF);
        dst[offset + 2] = (byte)(v >> 8 & 0xFF);
        dst[offset + 3] = (byte)(v >> 0 & 0xFF);
    }

    static int readInt(byte[] buffer, int pos) {
        int b1 = (buffer[pos] & 0xFF) << 24;
        int b2 = (buffer[pos + 1] & 0xFF) << 16;
        int b3 = (buffer[pos + 2] & 0xFF) << 8;
        int b4 = buffer[pos + 3] & 0xFF;
        return b1 | b2 | b3 | b4;
    }

    protected void dumpOutput() throws IOException {
        if (this.outputCursor > 0) {
            this.out.write(this.outputBuffer, 0, this.outputCursor);
            this.outputCursor = 0;
        }
    }

    protected void compressInput() throws IOException {
        if (!this.headerWritten) {
            this.outputCursor = this.writeHeader();
            this.headerWritten = true;
        }
        if (this.inputCursor <= 0) {
            return;
        }
        if (!this.hasSufficientOutputBufferFor(this.inputCursor)) {
            this.dumpOutput();
        }
        this.writeBlockPreemble();
        int compressedSize = Snappy.compress(this.inputBuffer, 0, this.inputCursor, this.outputBuffer, this.outputCursor + 4);
        SnappyOutputStream.writeInt(this.outputBuffer, this.outputCursor, compressedSize);
        this.outputCursor += 4 + compressedSize;
        this.inputCursor = 0;
    }

    protected int writeHeader() {
        return SnappyCodec.currentHeader.writeHeader(this.outputBuffer, 0);
    }

    protected void writeBlockPreemble() {
    }

    protected void writeCurrentDataSize() {
        SnappyOutputStream.writeInt(this.outputBuffer, this.outputCursor, this.inputCursor);
        this.outputCursor += 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.flush();
            this.out.close();
        }
        finally {
            this.closed = true;
            this.inputBufferAllocator.release(this.inputBuffer);
            this.outputBufferAllocator.release(this.outputBuffer);
            this.inputBuffer = null;
            this.outputBuffer = null;
        }
    }

    static {
        SnappyUtil.initLibPath();
        DEFAULT_MAX_COMPRESSED_LENGTH = Snappy.maxCompressedLength(32768);
    }
}

