/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.xerial.snappy.SnappyOutputStream;

public class SnappyCodec {
    static final byte[] MAGIC_HEADER = new byte[]{-126, 83, 78, 65, 80, 80, 89, 0};
    public static final int MAGIC_LEN = MAGIC_HEADER.length;
    public static final int HEADER_SIZE = MAGIC_LEN + 8;
    public static final int MAGIC_HEADER_HEAD = SnappyOutputStream.readInt(MAGIC_HEADER, 0);
    public static final int DEFAULT_VERSION = 1;
    public static final int MINIMUM_COMPATIBLE_VERSION = 1;
    public static final SnappyCodec currentHeader;
    public final byte[] magic;
    public final int version;
    public final int compatibleVersion;
    private final byte[] headerArray;

    private SnappyCodec(byte[] magic, int version, int compatibleVersion) {
        this.magic = magic;
        this.version = version;
        this.compatibleVersion = compatibleVersion;
        ByteArrayOutputStream header = new ByteArrayOutputStream(HEADER_SIZE);
        DataOutputStream d = new DataOutputStream(header);
        try {
            d.write(magic, 0, MAGIC_LEN);
            d.writeInt(version);
            d.writeInt(compatibleVersion);
            d.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.headerArray = header.toByteArray();
    }

    public static byte[] getMagicHeader() {
        return (byte[])MAGIC_HEADER.clone();
    }

    public String toString() {
        return String.format("version:%d, compatible version:%d", this.version, this.compatibleVersion);
    }

    public static int headerSize() {
        return HEADER_SIZE;
    }

    public int writeHeader(byte[] dst, int dstOffset) {
        System.arraycopy(this.headerArray, 0, dst, dstOffset, this.headerArray.length);
        return this.headerArray.length;
    }

    public int writeHeader(OutputStream out) throws IOException {
        out.write(this.headerArray, 0, this.headerArray.length);
        return this.headerArray.length;
    }

    public boolean isValidMagicHeader() {
        return Arrays.equals(MAGIC_HEADER, this.magic);
    }

    public static boolean hasMagicHeaderPrefix(byte[] b) {
        int limit = Math.min(MAGIC_LEN, b.length);
        for (int i = 0; i < limit; ++i) {
            if (b[i] == MAGIC_HEADER[i]) continue;
            return false;
        }
        return true;
    }

    public static SnappyCodec readHeader(InputStream in) throws IOException {
        DataInputStream d = new DataInputStream(in);
        byte[] magic = new byte[MAGIC_LEN];
        d.readFully(magic, 0, MAGIC_LEN);
        int version = d.readInt();
        int compatibleVersion = d.readInt();
        return new SnappyCodec(magic, version, compatibleVersion);
    }

    static {
        assert (MAGIC_HEADER_HEAD < 0);
        currentHeader = new SnappyCodec(MAGIC_HEADER, 1, 1);
    }
}

