/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayBackendHttpSettingsPropertiesFormat;
import com.azure.resourcemanager.network.models.ApplicationGatewayConnectionDraining;
import com.azure.resourcemanager.network.models.ApplicationGatewayCookieBasedAffinity;
import com.azure.resourcemanager.network.models.ApplicationGatewayProtocol;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ApplicationGatewayBackendHttpSettings
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ApplicationGatewayBackendHttpSettings.class);
    @JsonProperty(value="properties")
    private ApplicationGatewayBackendHttpSettingsPropertiesFormat innerProperties;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;

    private ApplicationGatewayBackendHttpSettingsPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public ApplicationGatewayBackendHttpSettings withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public ApplicationGatewayBackendHttpSettings withId(String id) {
        super.withId(id);
        return this;
    }

    public Integer port() {
        return this.innerProperties() == null ? null : this.innerProperties().port();
    }

    public ApplicationGatewayBackendHttpSettings withPort(Integer port) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayBackendHttpSettingsPropertiesFormat();
        }
        this.innerProperties().withPort(port);
        return this;
    }

    public ApplicationGatewayProtocol protocol() {
        return this.innerProperties() == null ? null : this.innerProperties().protocol();
    }

    public ApplicationGatewayBackendHttpSettings withProtocol(ApplicationGatewayProtocol protocol) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayBackendHttpSettingsPropertiesFormat();
        }
        this.innerProperties().withProtocol(protocol);
        return this;
    }

    public ApplicationGatewayCookieBasedAffinity cookieBasedAffinity() {
        return this.innerProperties() == null ? null : this.innerProperties().cookieBasedAffinity();
    }

    public ApplicationGatewayBackendHttpSettings withCookieBasedAffinity(ApplicationGatewayCookieBasedAffinity cookieBasedAffinity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayBackendHttpSettingsPropertiesFormat();
        }
        this.innerProperties().withCookieBasedAffinity(cookieBasedAffinity);
        return this;
    }

    public Integer requestTimeout() {
        return this.innerProperties() == null ? null : this.innerProperties().requestTimeout();
    }

    public ApplicationGatewayBackendHttpSettings withRequestTimeout(Integer requestTimeout) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayBackendHttpSettingsPropertiesFormat();
        }
        this.innerProperties().withRequestTimeout(requestTimeout);
        return this;
    }

    public SubResource probe() {
        return this.innerProperties() == null ? null : this.innerProperties().probe();
    }

    public ApplicationGatewayBackendHttpSettings withProbe(SubResource probe) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayBackendHttpSettingsPropertiesFormat();
        }
        this.innerProperties().withProbe(probe);
        return this;
    }

    public List<SubResource> authenticationCertificates() {
        return this.innerProperties() == null ? null : this.innerProperties().authenticationCertificates();
    }

    public ApplicationGatewayBackendHttpSettings withAuthenticationCertificates(List<SubResource> authenticationCertificates) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayBackendHttpSettingsPropertiesFormat();
        }
        this.innerProperties().withAuthenticationCertificates(authenticationCertificates);
        return this;
    }

    public List<SubResource> trustedRootCertificates() {
        return this.innerProperties() == null ? null : this.innerProperties().trustedRootCertificates();
    }

    public ApplicationGatewayBackendHttpSettings withTrustedRootCertificates(List<SubResource> trustedRootCertificates) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayBackendHttpSettingsPropertiesFormat();
        }
        this.innerProperties().withTrustedRootCertificates(trustedRootCertificates);
        return this;
    }

    public ApplicationGatewayConnectionDraining connectionDraining() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionDraining();
    }

    public ApplicationGatewayBackendHttpSettings withConnectionDraining(ApplicationGatewayConnectionDraining connectionDraining) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayBackendHttpSettingsPropertiesFormat();
        }
        this.innerProperties().withConnectionDraining(connectionDraining);
        return this;
    }

    public String hostname() {
        return this.innerProperties() == null ? null : this.innerProperties().hostname();
    }

    public ApplicationGatewayBackendHttpSettings withHostname(String hostname) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayBackendHttpSettingsPropertiesFormat();
        }
        this.innerProperties().withHostname(hostname);
        return this;
    }

    public Boolean pickHostnameFromBackendAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().pickHostnameFromBackendAddress();
    }

    public ApplicationGatewayBackendHttpSettings withPickHostnameFromBackendAddress(Boolean pickHostnameFromBackendAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayBackendHttpSettingsPropertiesFormat();
        }
        this.innerProperties().withPickHostnameFromBackendAddress(pickHostnameFromBackendAddress);
        return this;
    }

    public String affinityCookieName() {
        return this.innerProperties() == null ? null : this.innerProperties().affinityCookieName();
    }

    public ApplicationGatewayBackendHttpSettings withAffinityCookieName(String affinityCookieName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayBackendHttpSettingsPropertiesFormat();
        }
        this.innerProperties().withAffinityCookieName(affinityCookieName);
        return this;
    }

    public Boolean probeEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().probeEnabled();
    }

    public ApplicationGatewayBackendHttpSettings withProbeEnabled(Boolean probeEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayBackendHttpSettingsPropertiesFormat();
        }
        this.innerProperties().withProbeEnabled(probeEnabled);
        return this;
    }

    public String path() {
        return this.innerProperties() == null ? null : this.innerProperties().path();
    }

    public ApplicationGatewayBackendHttpSettings withPath(String path) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayBackendHttpSettingsPropertiesFormat();
        }
        this.innerProperties().withPath(path);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

