/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.VerificationIpFlowResultInner;
import com.azure.resourcemanager.network.implementation.NetworkWatcherImpl;
import com.azure.resourcemanager.network.models.Access;
import com.azure.resourcemanager.network.models.Direction;
import com.azure.resourcemanager.network.models.IpFlowProtocol;
import com.azure.resourcemanager.network.models.VerificationIPFlow;
import com.azure.resourcemanager.network.models.VerificationIpFlowParameters;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.ExecutableImpl;
import reactor.core.publisher.Mono;

public class VerificationIPFlowImpl
extends ExecutableImpl<VerificationIPFlow>
implements VerificationIPFlow,
VerificationIPFlow.Definition {
    private final NetworkWatcherImpl parent;
    private VerificationIpFlowParameters parameters = new VerificationIpFlowParameters();
    private VerificationIpFlowResultInner result;

    VerificationIPFlowImpl(NetworkWatcherImpl parent) {
        this.parent = parent;
    }

    @Override
    public VerificationIPFlowImpl withTargetResourceId(String targetResourceId) {
        this.parameters.withTargetResourceId(targetResourceId);
        return this;
    }

    @Override
    public VerificationIPFlowImpl withDirection(Direction direction) {
        this.parameters.withDirection(direction);
        return this;
    }

    @Override
    public VerificationIPFlow.DefinitionStages.WithProtocol inbound() {
        return this.withDirection(Direction.INBOUND);
    }

    @Override
    public VerificationIPFlow.DefinitionStages.WithProtocol outbound() {
        return this.withDirection(Direction.OUTBOUND);
    }

    @Override
    public VerificationIPFlowImpl withProtocol(IpFlowProtocol protocol) {
        this.parameters.withProtocol(protocol);
        return this;
    }

    @Override
    public VerificationIPFlow.DefinitionStages.WithLocalIP withTCP() {
        return this.withProtocol(IpFlowProtocol.TCP);
    }

    @Override
    public VerificationIPFlow.DefinitionStages.WithLocalIP withUDP() {
        return this.withProtocol(IpFlowProtocol.UDP);
    }

    @Override
    public VerificationIPFlowImpl withLocalPort(String localPort) {
        this.parameters.withLocalPort(localPort);
        return this;
    }

    @Override
    public VerificationIPFlowImpl withRemotePort(String remotePort) {
        this.parameters.withRemotePort(remotePort);
        return this;
    }

    @Override
    public VerificationIPFlowImpl withLocalIPAddress(String localIPAddress) {
        this.parameters.withLocalIpAddress(localIPAddress);
        return this;
    }

    @Override
    public VerificationIPFlowImpl withRemoteIPAddress(String remoteIPAddress) {
        this.parameters.withRemoteIpAddress(remoteIPAddress);
        return this;
    }

    @Override
    public VerificationIPFlow withTargetNetworkInterfaceId(String targetNetworkInterfaceId) {
        this.parameters.withTargetNicResourceId(targetNetworkInterfaceId);
        return this;
    }

    public NetworkWatcherImpl parent() {
        return this.parent;
    }

    @Override
    public Access access() {
        return this.result.access();
    }

    @Override
    public String ruleName() {
        return this.result.ruleName();
    }

    public Mono<VerificationIPFlow> executeWorkAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.parent().manager()).serviceClient()).getNetworkWatchers().verifyIpFlowAsync(this.parent.resourceGroupName(), this.parent.name(), this.parameters).map(verificationIPFlowResultInner -> {
            this.result = verificationIPFlowResultInner;
            return this;
        });
    }
}

