/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.VirtualNetworksClient;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkInner;
import com.azure.resourcemanager.network.implementation.NetworkImpl;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.DhcpOptions;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.Networks;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.util.ArrayList;

public class NetworksImpl
extends TopLevelModifiableResourcesImpl<Network, NetworkImpl, VirtualNetworkInner, VirtualNetworksClient, NetworkManager>
implements Networks {
    public NetworksImpl(NetworkManager networkManager) {
        super((InnerSupportsListing)((NetworkManagementClient)networkManager.serviceClient()).getVirtualNetworks(), (Manager)networkManager);
    }

    public NetworkImpl define(String name) {
        return this.wrapModel(name);
    }

    protected NetworkImpl wrapModel(String name) {
        DhcpOptions dhcp;
        VirtualNetworkInner inner = new VirtualNetworkInner();
        AddressSpace addressSpace = inner.addressSpace();
        if (addressSpace == null) {
            addressSpace = new AddressSpace();
            inner.withAddressSpace(addressSpace);
        }
        if (addressSpace.addressPrefixes() == null) {
            addressSpace.withAddressPrefixes(new ArrayList<String>());
        }
        if (inner.subnets() == null) {
            inner.withSubnets(new ArrayList<SubnetInner>());
        }
        if ((dhcp = inner.dhcpOptions()) == null) {
            dhcp = new DhcpOptions();
            inner.withDhcpOptions(dhcp);
        }
        if (dhcp.dnsServers() == null) {
            dhcp.withDnsServers(new ArrayList<String>());
        }
        return new NetworkImpl(name, inner, (NetworkManager)super.manager());
    }

    protected NetworkImpl wrapModel(VirtualNetworkInner inner) {
        if (inner == null) {
            return null;
        }
        return new NetworkImpl(inner.name(), inner, (NetworkManager)this.manager());
    }
}

