/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.VirtualNetworkPeeringsClient;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkPeeringInner;
import com.azure.resourcemanager.network.implementation.NetworkImpl;
import com.azure.resourcemanager.network.implementation.NetworkPeeringImpl;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.NetworkPeering;
import com.azure.resourcemanager.network.models.NetworkPeerings;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.IndependentChildrenImpl;
import reactor.core.publisher.Mono;

class NetworkPeeringsImpl
extends IndependentChildrenImpl<NetworkPeering, NetworkPeeringImpl, VirtualNetworkPeeringInner, VirtualNetworkPeeringsClient, NetworkManager, Network>
implements NetworkPeerings {
    private final NetworkImpl network;

    NetworkPeeringsImpl(NetworkImpl parent) {
        super((Object)((NetworkManagementClient)((NetworkManager)parent.manager()).serviceClient()).getVirtualNetworkPeerings(), (Manager)((NetworkManager)parent.manager()));
        this.network = parent;
    }

    public NetworkPeeringImpl define(String name) {
        return this.wrapModel(name);
    }

    protected NetworkPeeringImpl wrapModel(String name) {
        VirtualNetworkPeeringInner inner = new VirtualNetworkPeeringInner().withName(name);
        return new NetworkPeeringImpl(inner, this.network);
    }

    protected NetworkPeeringImpl wrapModel(VirtualNetworkPeeringInner inner) {
        return inner != null ? new NetworkPeeringImpl(inner, this.network) : null;
    }

    public Mono<Void> deleteByParentAsync(String groupName, String parentName, String name) {
        return ((NetworkManager)this.manager()).networks().getByResourceGroupAsync(groupName, parentName).flatMap(localNetwork -> {
            if (localNetwork == null) {
                return Mono.empty();
            }
            String peeringId = localNetwork.id() + "/peerings/" + name;
            return localNetwork.peerings().getByIdAsync(peeringId);
        }).flux().flatMap(localPeering -> {
            if (localPeering == null) {
                return Mono.empty();
            }
            if (!localPeering.isSameSubscription()) {
                return Mono.just((Object)localPeering);
            }
            return Mono.just((Object)localPeering).concatWith(localPeering.getRemotePeeringAsync());
        }).flatMap(peering -> {
            if (peering == null) {
                return Mono.empty();
            }
            String networkName = ResourceUtils.nameFromResourceId((String)peering.networkId());
            return ((NetworkManagementClient)((NetworkManager)((Object)((Object)peering.manager()))).serviceClient()).getVirtualNetworkPeerings().deleteAsync(peering.resourceGroupName(), networkName, peering.name());
        }).then();
    }

    public Mono<NetworkPeering> getByParentAsync(String resourceGroup, String parentName, String name) {
        return ((VirtualNetworkPeeringsClient)this.innerModel()).getAsync(resourceGroup, parentName, name).map(inner -> this.wrapModel((VirtualNetworkPeeringInner)((Object)inner)));
    }

    public PagedIterable<NetworkPeering> listByParent(String resourceGroupName, String parentName) {
        return this.wrapList(((VirtualNetworkPeeringsClient)this.innerModel()).list(resourceGroupName, parentName));
    }

    public PagedIterable<NetworkPeering> list() {
        return this.wrapList(((VirtualNetworkPeeringsClient)this.innerModel()).list(this.network.resourceGroupName(), this.network.name()));
    }

    public PagedFlux<NetworkPeering> listAsync() {
        return this.wrapPageAsync(((VirtualNetworkPeeringsClient)this.innerModel()).listAsync(this.network.resourceGroupName(), this.network.name()));
    }

    @Override
    public NetworkPeering getByRemoteNetwork(Network network) {
        return network != null ? this.getByRemoteNetwork(network.id()) : null;
    }

    @Override
    public NetworkPeering getByRemoteNetwork(String remoteNetworkResourceId) {
        if (remoteNetworkResourceId != null) {
            for (NetworkPeering peering : this.list()) {
                if (!peering.remoteNetworkId().equalsIgnoreCase(remoteNetworkResourceId)) continue;
                return peering;
            }
        }
        return null;
    }

    @Override
    public Mono<NetworkPeering> getByRemoteNetworkAsync(Network network) {
        if (network != null) {
            return this.getByRemoteNetworkAsync(network.id());
        }
        return Mono.empty();
    }

    @Override
    public Mono<NetworkPeering> getByRemoteNetworkAsync(String remoteNetworkResourceId) {
        if (remoteNetworkResourceId == null) {
            return Mono.empty();
        }
        return this.listAsync().filter(peering -> {
            if (peering == null) {
                return false;
            }
            return remoteNetworkResourceId.equalsIgnoreCase(peering.remoteNetworkId());
        }).last();
    }
}

