/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.ApplicationSecurityGroupInner;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceInner;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.models.CustomDnsConfigPropertiesFormat;
import com.azure.resourcemanager.network.models.PrivateEndpointIpConfiguration;
import com.azure.resourcemanager.network.models.PrivateLinkServiceConnection;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class PrivateEndpointPropertiesInner {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(PrivateEndpointPropertiesInner.class);
    @JsonProperty(value="subnet")
    private SubnetInner subnet;
    @JsonProperty(value="networkInterfaces", access=JsonProperty.Access.WRITE_ONLY)
    private List<NetworkInterfaceInner> networkInterfaces;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="privateLinkServiceConnections")
    private List<PrivateLinkServiceConnection> privateLinkServiceConnections;
    @JsonProperty(value="manualPrivateLinkServiceConnections")
    private List<PrivateLinkServiceConnection> manualPrivateLinkServiceConnections;
    @JsonProperty(value="customDnsConfigs")
    private List<CustomDnsConfigPropertiesFormat> customDnsConfigs;
    @JsonProperty(value="applicationSecurityGroups")
    private List<ApplicationSecurityGroupInner> applicationSecurityGroups;
    @JsonProperty(value="ipConfigurations")
    private List<PrivateEndpointIpConfiguration> ipConfigurations;
    @JsonProperty(value="customNetworkInterfaceName")
    private String customNetworkInterfaceName;

    public SubnetInner subnet() {
        return this.subnet;
    }

    public PrivateEndpointPropertiesInner withSubnet(SubnetInner subnet) {
        this.subnet = subnet;
        return this;
    }

    public List<NetworkInterfaceInner> networkInterfaces() {
        return this.networkInterfaces;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<PrivateLinkServiceConnection> privateLinkServiceConnections() {
        return this.privateLinkServiceConnections;
    }

    public PrivateEndpointPropertiesInner withPrivateLinkServiceConnections(List<PrivateLinkServiceConnection> privateLinkServiceConnections) {
        this.privateLinkServiceConnections = privateLinkServiceConnections;
        return this;
    }

    public List<PrivateLinkServiceConnection> manualPrivateLinkServiceConnections() {
        return this.manualPrivateLinkServiceConnections;
    }

    public PrivateEndpointPropertiesInner withManualPrivateLinkServiceConnections(List<PrivateLinkServiceConnection> manualPrivateLinkServiceConnections) {
        this.manualPrivateLinkServiceConnections = manualPrivateLinkServiceConnections;
        return this;
    }

    public List<CustomDnsConfigPropertiesFormat> customDnsConfigs() {
        return this.customDnsConfigs;
    }

    public PrivateEndpointPropertiesInner withCustomDnsConfigs(List<CustomDnsConfigPropertiesFormat> customDnsConfigs) {
        this.customDnsConfigs = customDnsConfigs;
        return this;
    }

    public List<ApplicationSecurityGroupInner> applicationSecurityGroups() {
        return this.applicationSecurityGroups;
    }

    public PrivateEndpointPropertiesInner withApplicationSecurityGroups(List<ApplicationSecurityGroupInner> applicationSecurityGroups) {
        this.applicationSecurityGroups = applicationSecurityGroups;
        return this;
    }

    public List<PrivateEndpointIpConfiguration> ipConfigurations() {
        return this.ipConfigurations;
    }

    public PrivateEndpointPropertiesInner withIpConfigurations(List<PrivateEndpointIpConfiguration> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    public String customNetworkInterfaceName() {
        return this.customNetworkInterfaceName;
    }

    public PrivateEndpointPropertiesInner withCustomNetworkInterfaceName(String customNetworkInterfaceName) {
        this.customNetworkInterfaceName = customNetworkInterfaceName;
        return this;
    }

    public void validate() {
        if (this.subnet() != null) {
            this.subnet().validate();
        }
        if (this.networkInterfaces() != null) {
            this.networkInterfaces().forEach(e -> e.validate());
        }
        if (this.privateLinkServiceConnections() != null) {
            this.privateLinkServiceConnections().forEach(e -> e.validate());
        }
        if (this.manualPrivateLinkServiceConnections() != null) {
            this.manualPrivateLinkServiceConnections().forEach(e -> e.validate());
        }
        if (this.customDnsConfigs() != null) {
            this.customDnsConfigs().forEach(e -> e.validate());
        }
        if (this.applicationSecurityGroups() != null) {
            this.applicationSecurityGroups().forEach(e -> e.validate());
        }
        if (this.ipConfigurations() != null) {
            this.ipConfigurations().forEach(e -> e.validate());
        }
    }
}

