/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.BgpSettings;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class LocalNetworkGatewayPropertiesFormat {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(LocalNetworkGatewayPropertiesFormat.class);
    @JsonProperty(value="localNetworkAddressSpace")
    private AddressSpace localNetworkAddressSpace;
    @JsonProperty(value="gatewayIpAddress")
    private String gatewayIpAddress;
    @JsonProperty(value="fqdn")
    private String fqdn;
    @JsonProperty(value="bgpSettings")
    private BgpSettings bgpSettings;
    @JsonProperty(value="resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public AddressSpace localNetworkAddressSpace() {
        return this.localNetworkAddressSpace;
    }

    public LocalNetworkGatewayPropertiesFormat withLocalNetworkAddressSpace(AddressSpace localNetworkAddressSpace) {
        this.localNetworkAddressSpace = localNetworkAddressSpace;
        return this;
    }

    public String gatewayIpAddress() {
        return this.gatewayIpAddress;
    }

    public LocalNetworkGatewayPropertiesFormat withGatewayIpAddress(String gatewayIpAddress) {
        this.gatewayIpAddress = gatewayIpAddress;
        return this;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public LocalNetworkGatewayPropertiesFormat withFqdn(String fqdn) {
        this.fqdn = fqdn;
        return this;
    }

    public BgpSettings bgpSettings() {
        return this.bgpSettings;
    }

    public LocalNetworkGatewayPropertiesFormat withBgpSettings(BgpSettings bgpSettings) {
        this.bgpSettings = bgpSettings;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.localNetworkAddressSpace() != null) {
            this.localNetworkAddressSpace().validate();
        }
        if (this.bgpSettings() != null) {
            this.bgpSettings().validate();
        }
    }
}

