/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteConnectionInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteGatewayProperties;
import com.azure.resourcemanager.network.models.ExpressRouteGatewayPropertiesAutoScaleConfiguration;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualHubId;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class ExpressRouteGatewayInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ExpressRouteGatewayInner.class);
    @JsonProperty(value="properties")
    private ExpressRouteGatewayProperties innerProperties;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="id")
    private String id;

    private ExpressRouteGatewayProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public ExpressRouteGatewayInner withId(String id) {
        this.id = id;
        return this;
    }

    public ExpressRouteGatewayInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ExpressRouteGatewayInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ExpressRouteGatewayPropertiesAutoScaleConfiguration autoScaleConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().autoScaleConfiguration();
    }

    public ExpressRouteGatewayInner withAutoScaleConfiguration(ExpressRouteGatewayPropertiesAutoScaleConfiguration autoScaleConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteGatewayProperties();
        }
        this.innerProperties().withAutoScaleConfiguration(autoScaleConfiguration);
        return this;
    }

    public List<ExpressRouteConnectionInner> expressRouteConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().expressRouteConnections();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public VirtualHubId virtualHub() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualHub();
    }

    public ExpressRouteGatewayInner withVirtualHub(VirtualHubId virtualHub) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteGatewayProperties();
        }
        this.innerProperties().withVirtualHub(virtualHub);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

