/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.ManagedInstanceEncryptionProtectorsClient;
import com.azure.resourcemanager.sql.fluent.models.ManagedInstanceEncryptionProtectorInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.EncryptionProtectorName;
import com.azure.resourcemanager.sql.models.ManagedInstanceEncryptionProtectorListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ManagedInstanceEncryptionProtectorsClientImpl
implements ManagedInstanceEncryptionProtectorsClient {
    private final ClientLogger logger = new ClientLogger(ManagedInstanceEncryptionProtectorsClientImpl.class);
    private final ManagedInstanceEncryptionProtectorsService service;
    private final SqlManagementClientImpl client;

    ManagedInstanceEncryptionProtectorsClientImpl(SqlManagementClientImpl client) {
        this.service = (ManagedInstanceEncryptionProtectorsService)RestProxy.create(ManagedInstanceEncryptionProtectorsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> revalidateWithResponseAsync(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (encryptionProtectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter encryptionProtectorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        return FluxUtil.withContext(context -> this.service.revalidate(this.client.getEndpoint(), resourceGroupName, managedInstanceName, encryptionProtectorName, this.client.getSubscriptionId(), "2017-10-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> revalidateWithResponseAsync(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (encryptionProtectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter encryptionProtectorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        context = this.client.mergeContext(context);
        return this.service.revalidate(this.client.getEndpoint(), resourceGroupName, managedInstanceName, encryptionProtectorName, this.client.getSubscriptionId(), "2017-10-01-preview", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginRevalidateAsync(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.revalidateWithResponseAsync(resourceGroupName, managedInstanceName, encryptionProtectorName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginRevalidateAsync(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.revalidateWithResponseAsync(resourceGroupName, managedInstanceName, encryptionProtectorName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginRevalidate(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName) {
        return this.beginRevalidateAsync(resourceGroupName, managedInstanceName, encryptionProtectorName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginRevalidate(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName, Context context) {
        return this.beginRevalidateAsync(resourceGroupName, managedInstanceName, encryptionProtectorName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> revalidateAsync(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName) {
        return this.beginRevalidateAsync(resourceGroupName, managedInstanceName, encryptionProtectorName).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> revalidateAsync(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName, Context context) {
        return this.beginRevalidateAsync(resourceGroupName, managedInstanceName, encryptionProtectorName, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void revalidate(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName) {
        this.revalidateAsync(resourceGroupName, managedInstanceName, encryptionProtectorName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void revalidate(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName, Context context) {
        this.revalidateAsync(resourceGroupName, managedInstanceName, encryptionProtectorName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedInstanceEncryptionProtectorInner>> listByInstanceSinglePageAsync(String resourceGroupName, String managedInstanceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        return FluxUtil.withContext(context -> this.service.listByInstance(this.client.getEndpoint(), resourceGroupName, managedInstanceName, this.client.getSubscriptionId(), "2017-10-01-preview", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedInstanceEncryptionProtectorListResult)res.getValue()).value(), ((ManagedInstanceEncryptionProtectorListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedInstanceEncryptionProtectorInner>> listByInstanceSinglePageAsync(String resourceGroupName, String managedInstanceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        context = this.client.mergeContext(context);
        return this.service.listByInstance(this.client.getEndpoint(), resourceGroupName, managedInstanceName, this.client.getSubscriptionId(), "2017-10-01-preview", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedInstanceEncryptionProtectorListResult)res.getValue()).value(), ((ManagedInstanceEncryptionProtectorListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ManagedInstanceEncryptionProtectorInner> listByInstanceAsync(String resourceGroupName, String managedInstanceName) {
        return new PagedFlux(() -> this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName), nextLink -> this.listByInstanceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ManagedInstanceEncryptionProtectorInner> listByInstanceAsync(String resourceGroupName, String managedInstanceName, Context context) {
        return new PagedFlux(() -> this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName, context), nextLink -> this.listByInstanceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedInstanceEncryptionProtectorInner> listByInstance(String resourceGroupName, String managedInstanceName) {
        return new PagedIterable(this.listByInstanceAsync(resourceGroupName, managedInstanceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedInstanceEncryptionProtectorInner> listByInstance(String resourceGroupName, String managedInstanceName, Context context) {
        return new PagedIterable(this.listByInstanceAsync(resourceGroupName, managedInstanceName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ManagedInstanceEncryptionProtectorInner>> getWithResponseAsync(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (encryptionProtectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter encryptionProtectorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, managedInstanceName, encryptionProtectorName, this.client.getSubscriptionId(), "2017-10-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ManagedInstanceEncryptionProtectorInner>> getWithResponseAsync(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (encryptionProtectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter encryptionProtectorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-10-01-preview";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, managedInstanceName, encryptionProtectorName, this.client.getSubscriptionId(), "2017-10-01-preview", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ManagedInstanceEncryptionProtectorInner> getAsync(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName) {
        return this.getWithResponseAsync(resourceGroupName, managedInstanceName, encryptionProtectorName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ManagedInstanceEncryptionProtectorInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedInstanceEncryptionProtectorInner get(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName) {
        return (ManagedInstanceEncryptionProtectorInner)((Object)this.getAsync(resourceGroupName, managedInstanceName, encryptionProtectorName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ManagedInstanceEncryptionProtectorInner> getWithResponse(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, managedInstanceName, encryptionProtectorName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName, ManagedInstanceEncryptionProtectorInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (encryptionProtectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter encryptionProtectorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2017-10-01-preview";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, managedInstanceName, encryptionProtectorName, this.client.getSubscriptionId(), "2017-10-01-preview", parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName, ManagedInstanceEncryptionProtectorInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (encryptionProtectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter encryptionProtectorName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2017-10-01-preview";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, managedInstanceName, encryptionProtectorName, this.client.getSubscriptionId(), "2017-10-01-preview", parameters, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<ManagedInstanceEncryptionProtectorInner>, ManagedInstanceEncryptionProtectorInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName, ManagedInstanceEncryptionProtectorInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, managedInstanceName, encryptionProtectorName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ManagedInstanceEncryptionProtectorInner.class), (Type)((Object)ManagedInstanceEncryptionProtectorInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<ManagedInstanceEncryptionProtectorInner>, ManagedInstanceEncryptionProtectorInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName, ManagedInstanceEncryptionProtectorInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, managedInstanceName, encryptionProtectorName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ManagedInstanceEncryptionProtectorInner.class), (Type)((Object)ManagedInstanceEncryptionProtectorInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<ManagedInstanceEncryptionProtectorInner>, ManagedInstanceEncryptionProtectorInner> beginCreateOrUpdate(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName, ManagedInstanceEncryptionProtectorInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, managedInstanceName, encryptionProtectorName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<ManagedInstanceEncryptionProtectorInner>, ManagedInstanceEncryptionProtectorInner> beginCreateOrUpdate(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName, ManagedInstanceEncryptionProtectorInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, managedInstanceName, encryptionProtectorName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ManagedInstanceEncryptionProtectorInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName, ManagedInstanceEncryptionProtectorInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, managedInstanceName, encryptionProtectorName, parameters).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ManagedInstanceEncryptionProtectorInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName, ManagedInstanceEncryptionProtectorInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, managedInstanceName, encryptionProtectorName, parameters, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedInstanceEncryptionProtectorInner createOrUpdate(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName, ManagedInstanceEncryptionProtectorInner parameters) {
        return (ManagedInstanceEncryptionProtectorInner)((Object)this.createOrUpdateAsync(resourceGroupName, managedInstanceName, encryptionProtectorName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedInstanceEncryptionProtectorInner createOrUpdate(String resourceGroupName, String managedInstanceName, EncryptionProtectorName encryptionProtectorName, ManagedInstanceEncryptionProtectorInner parameters, Context context) {
        return (ManagedInstanceEncryptionProtectorInner)((Object)this.createOrUpdateAsync(resourceGroupName, managedInstanceName, encryptionProtectorName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedInstanceEncryptionProtectorInner>> listByInstanceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByInstanceNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedInstanceEncryptionProtectorListResult)res.getValue()).value(), ((ManagedInstanceEncryptionProtectorListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedInstanceEncryptionProtectorInner>> listByInstanceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByInstanceNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedInstanceEncryptionProtectorListResult)res.getValue()).value(), ((ManagedInstanceEncryptionProtectorListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientM")
    private static interface ManagedInstanceEncryptionProtectorsService {
        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/encryptionProtector/{encryptionProtectorName}/revalidate")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> revalidate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="encryptionProtectorName") EncryptionProtectorName var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/encryptionProtector")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedInstanceEncryptionProtectorListResult>> listByInstance(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/encryptionProtector/{encryptionProtectorName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedInstanceEncryptionProtectorInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="encryptionProtectorName") EncryptionProtectorName var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/encryptionProtector/{encryptionProtectorName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="encryptionProtectorName") EncryptionProtectorName var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ManagedInstanceEncryptionProtectorInner var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedInstanceEncryptionProtectorListResult>> listByInstanceNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

