/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.containerinstance.fluent.ContainerGroupsClient;
import com.azure.resourcemanager.containerinstance.fluent.ContainerInstanceManagementClient;
import com.azure.resourcemanager.containerinstance.fluent.ContainersClient;
import com.azure.resourcemanager.containerinstance.fluent.LocationsClient;
import com.azure.resourcemanager.containerinstance.fluent.OperationsClient;
import com.azure.resourcemanager.containerinstance.implementation.ContainerGroupsClientImpl;
import com.azure.resourcemanager.containerinstance.implementation.ContainerInstanceManagementClientBuilder;
import com.azure.resourcemanager.containerinstance.implementation.ContainersClientImpl;
import com.azure.resourcemanager.containerinstance.implementation.LocationsClientImpl;
import com.azure.resourcemanager.containerinstance.implementation.OperationsClientImpl;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import java.time.Duration;

@ServiceClient(builder=ContainerInstanceManagementClientBuilder.class)
public final class ContainerInstanceManagementClientImpl
extends AzureServiceClient
implements ContainerInstanceManagementClient {
    private final ClientLogger logger = new ClientLogger(ContainerInstanceManagementClientImpl.class);
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final ContainerGroupsClient containerGroups;
    private final OperationsClient operations;
    private final LocationsClient locations;
    private final ContainersClient containers;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public ContainerGroupsClient getContainerGroups() {
        return this.containerGroups;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public LocationsClient getLocations() {
        return this.locations;
    }

    @Override
    public ContainersClient getContainers() {
        return this.containers;
    }

    ContainerInstanceManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2021-09-01";
        this.containerGroups = new ContainerGroupsClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.locations = new LocationsClientImpl(this);
        this.containers = new ContainersClientImpl(this);
    }
}

