/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.xjc;

import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaModel;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaAnnotationImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaClassImpl;

public class XJCJavaModelImpl
implements JavaModel {
    private JCodeModel jCodeModel;
    private DynamicClassLoader dynamicClassLoader;
    private Map<String, JavaClass> javaModelClasses = new HashMap<String, JavaClass>();

    public XJCJavaModelImpl(JCodeModel codeModel, DynamicClassLoader loader) {
        this.jCodeModel = codeModel;
        this.dynamicClassLoader = loader;
    }

    @Override
    public JavaClass getClass(Class<?> jClass) {
        if (jClass == null) {
            return null;
        }
        JavaClass cachedClass = this.javaModelClasses.get(jClass.getCanonicalName());
        if (cachedClass != null) {
            return cachedClass;
        }
        try {
            XJCJavaClassImpl jc = new XJCJavaClassImpl(this.jCodeModel._class(jClass.getCanonicalName()), this.jCodeModel, this.dynamicClassLoader);
            jc.setJavaModel(this);
            this.javaModelClasses.put(jClass.getCanonicalName(), jc);
            return jc;
        }
        catch (JClassAlreadyExistsException ex) {
            XJCJavaClassImpl jc = new XJCJavaClassImpl(this.jCodeModel._getClass(jClass.getCanonicalName()), this.jCodeModel, this.dynamicClassLoader);
            this.javaModelClasses.put(jClass.getCanonicalName(), jc);
            jc.setJavaModel(this);
            return jc;
        }
    }

    @Override
    public JavaClass getClass(String className) {
        boolean isTyped;
        JavaClass cachedClass = this.javaModelClasses.get(className);
        if (cachedClass != null) {
            return cachedClass;
        }
        String componentName = className;
        boolean isArray = className.contains("[]");
        if (isArray) {
            componentName = className.replace("[]", "");
        }
        if (isTyped = className.contains("<")) {
            componentName = componentName.substring(0, className.indexOf(60));
        }
        boolean isPrimitive = XMLConversionManager.getPrimitiveClass((String)componentName) != null;
        try {
            XJCJavaClassImpl jc = new XJCJavaClassImpl(this.jCodeModel._class(componentName), this.jCodeModel, this.dynamicClassLoader, isArray, isPrimitive);
            this.javaModelClasses.put(className, jc);
            return jc;
        }
        catch (JClassAlreadyExistsException ex) {
            XJCJavaClassImpl jc = new XJCJavaClassImpl(this.jCodeModel._getClass(componentName), this.jCodeModel, this.dynamicClassLoader, isArray, isPrimitive);
            this.javaModelClasses.put(className, jc);
            return jc;
        }
    }

    @Override
    public Annotation getAnnotation(JavaAnnotation annotation, Class<?> jClass) {
        return ((XJCJavaAnnotationImpl)annotation).getJavaAnnotation();
    }

    public Map<String, JavaClass> getJavaModelClasses() {
        return this.javaModelClasses;
    }

    public void setJavaModelClasses(Map<String, JavaClass> javaModelClasses) {
        this.javaModelClasses = javaModelClasses;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.dynamicClassLoader;
    }
}

