/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.validator.validwhen;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.struts.validator.validwhen.ValidWhenResult;

public enum ValidWhenComparison {
    LESS_EQUAL(20){

        @Override
        protected boolean compareTo(int compareTo) {
            return compareTo <= 0;
        }
    }
    ,
    LESS_THAN(18){

        @Override
        protected boolean compareTo(int compareTo) {
            return compareTo < 0;
        }
    }
    ,
    EQUAL(16){

        @Override
        protected boolean compareWithNull(Object v1, Object v2) {
            return v1 == v2;
        }

        @Override
        protected boolean compareTo(int compareTo) {
            return compareTo == 0;
        }
    }
    ,
    GREATER_THAN(19){

        @Override
        protected boolean compareTo(int compareTo) {
            return compareTo > 0;
        }
    }
    ,
    GREATER_EQUAL(21){

        @Override
        protected boolean compareTo(int compareTo) {
            return compareTo >= 0;
        }
    }
    ,
    NOT_EQUAL(17){

        @Override
        protected boolean compareWithNull(Object v1, Object v2) {
            return v1 != v2;
        }

        @Override
        protected boolean compareTo(int compareTo) {
            return compareTo != 0;
        }
    };

    private static final Map<Integer, ValidWhenComparison> COMP_MAPPER;
    private final int tokenNum;

    public static ValidWhenComparison getComp(int tokenNum) {
        return COMP_MAPPER.get(tokenNum);
    }

    private ValidWhenComparison(int tokenNum) {
        this.tokenNum = tokenNum;
    }

    protected boolean compareWithNull(Object v1, Object v2) {
        return false;
    }

    protected <T extends Comparable<T>> boolean compareTo(T v1, T v2) {
        return this.compareTo(v1.compareTo(v2));
    }

    protected abstract boolean compareTo(int var1);

    public boolean compare(ValidWhenResult<?> v1, ValidWhenResult<?> v2) {
        Object o1 = v1.getValue();
        Object o2 = v2.getValue();
        if (o1 == null || o2 == null) {
            return this.compareWithNull(o1, o2);
        }
        try {
            BigDecimal i1 = ValidWhenComparison.convertBigDecimal(o1);
            BigDecimal i2 = ValidWhenComparison.convertBigDecimal(o2);
            return this.compareTo(i1, i2);
        }
        catch (NumberFormatException i1) {
            String s1 = v1.toString();
            String s2 = v2.toString();
            return this.compareTo(s1, s2);
        }
    }

    private static BigDecimal convertBigDecimal(Object val) {
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        if (val instanceof Integer) {
            return new BigDecimal((Integer)val);
        }
        return new BigDecimal(val.toString());
    }

    static {
        COMP_MAPPER = new HashMap<Integer, ValidWhenComparison>();
        for (ValidWhenComparison comp : ValidWhenComparison.values()) {
            COMP_MAPPER.put(comp.tokenNum, comp);
        }
    }
}

