/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.validator.validwhen;

import jakarta.servlet.http.HttpServletRequest;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.apache.struts.validator.Resources;
import org.apache.struts.validator.validwhen.ValidWhenEvaluator;
import org.apache.struts.validator.validwhen.ValidWhenLexer;
import org.apache.struts.validator.validwhen.ValidWhenParser;
import org.apache.struts.validator.validwhen.ValidWhenResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidWhen {
    private static final Logger LOG = LoggerFactory.getLogger(ValidWhen.class);
    private static MessageResources sysmsgs = MessageResources.getMessageResources("org.apache.struts.validator.LocalStrings");

    private static boolean isString(Object obj) {
        return obj == null ? true : String.class.isInstance(obj);
    }

    public static boolean validateValidWhen(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        Object form = validator.getParameterValue("java.lang.Object");
        String value = null;
        boolean valid = false;
        int index = -1;
        if (field.isIndexed()) {
            String key = field.getKey();
            int leftBracket = key.indexOf("[");
            int rightBracket = key.indexOf("]");
            if (leftBracket > -1 && rightBracket > -1) {
                index = Integer.parseInt(key.substring(leftBracket + 1, rightBracket));
            }
        }
        value = ValidWhen.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        String test = null;
        try {
            test = Resources.getVarValue("test", field, validator, request, true);
        }
        catch (IllegalArgumentException ex) {
            LOG.atError().log(() -> sysmsgs.getMessage("validation.failed", (Object)"validwhen", (Object)field.getProperty(), (Object)validator.getFormName(), (Object)ex.toString()));
            String userErrorMsg = sysmsgs.getMessage("system.error");
            errors.add(field.getKey(), new ActionMessage(userErrorMsg, false));
            return false;
        }
        ValidWhenLexer lexer = null;
        try {
            lexer = new ValidWhenLexer((CharStream)CharStreams.fromString((String)test));
        }
        catch (Exception ex) {
            LOG.error("ValidWhenLexer Error for field '{}'", (Object)field.getKey(), (Object)ex);
            String userErrorMsg = sysmsgs.getMessage("system.error");
            errors.add(field.getKey(), new ActionMessage(userErrorMsg, false));
            return false;
        }
        ValidWhenParser parser = null;
        try {
            parser = new ValidWhenParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        }
        catch (Exception ex) {
            LOG.error("ValidWhenParser Error for field '{}'", (Object)field.getKey(), (Object)ex);
            String userErrorMsg = sysmsgs.getMessage("system.error");
            errors.add(field.getKey(), new ActionMessage(userErrorMsg, false));
            return false;
        }
        ValidWhenEvaluator validWhenEvaluator = new ValidWhenEvaluator(form, value, index);
        try {
            ValidWhenParser.ExpressionContext expressionContext = parser.expression();
            Object result = validWhenEvaluator.visitExpression(expressionContext);
            valid = result == null ? false : ((ValidWhenResult)result).toBoolean();
        }
        catch (Exception ex) {
            LOG.error("ValidWhen Error for field '{}'", (Object)field.getKey(), (Object)ex);
            String userErrorMsg = sysmsgs.getMessage("system.error");
            errors.add(field.getKey(), new ActionMessage(userErrorMsg, false));
            return false;
        }
        if (!valid) {
            errors.add(field.getKey(), Resources.getActionMessage(validator, request, va, field));
            return false;
        }
        return true;
    }
}

