/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.validator;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResults;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.validator.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynaValidatorForm
extends DynaActionForm
implements DynaBean,
Serializable {
    private static final long serialVersionUID = -3390223591247112687L;
    private final transient Logger log = LoggerFactory.getLogger(DynaValidatorForm.class);
    protected ValidatorResults validatorResults = null;
    protected int page = 0;

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        this.setPageFromDynaProperty();
        ServletContext application = this.getServlet().getServletContext();
        ActionErrors errors = new ActionErrors();
        String validationKey = this.getValidationKey(mapping, request);
        int validationPage = this.determinePage(mapping, request);
        Validator validator = Resources.initValidator(validationKey, this, application, request, errors, validationPage);
        try {
            this.validatorResults = validator.validate();
        }
        catch (ValidatorException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return errors;
    }

    protected int determinePage(ActionMapping mapping, HttpServletRequest request) {
        Integer acceptPage = mapping.getAcceptPage();
        return acceptPage != null ? Math.max(acceptPage, this.getPage()) : Integer.MAX_VALUE;
    }

    public String getValidationKey(ActionMapping mapping, HttpServletRequest request) {
        return mapping.getAttribute();
    }

    protected void setPageFromDynaProperty() {
        Map<String, Object> props = this.getMap();
        if (props.containsKey("page")) {
            Integer p = null;
            try {
                p = (Integer)props.get("page");
            }
            catch (ClassCastException e) {
                this.log.error("Dyna 'page' property must be of type java.lang.Integer.", (Throwable)e);
                throw e;
            }
            if (p == null) {
                throw new NullPointerException("Dyna 'page' property must not be null.  Either provide an initial value or set 'convertNull' to false. ");
            }
            this.page = p;
        }
    }

    @Override
    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.page = 0;
        this.validatorResults = null;
    }

    public ValidatorResults getValidatorResults() {
        return this.validatorResults;
    }

    public void setValidatorResults(ValidatorResults validatorResults) {
        this.validatorResults = validatorResults;
    }

    public Map<String, Object> getResultValueMap() {
        return this.validatorResults != null ? this.validatorResults.getResultValueMap() : null;
    }
}

