/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.struts.util.MessageResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseUtils.class);
    private static final Pattern XML_ENTITY_PATTERN = Pattern.compile("&(?:[a-zA-Z][a-zA-Z\\d]*|#\\d+|#x[a-fA-F\\d]+);");
    protected static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.util.LocalStrings");

    protected ResponseUtils() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String filter(String value) {
        String string;
        if (value == null) return value;
        if (value.isEmpty()) {
            return value;
        }
        int length = value.length();
        StringBuilder result = null;
        Matcher entityMatcher = null;
        block7: for (int i = 0; i < length; ++i) {
            String filtered = null;
            switch (value.charAt(i)) {
                case '<': {
                    filtered = "&lt;";
                    break;
                }
                case '>': {
                    filtered = "&gt;";
                    break;
                }
                case '&': {
                    if (entityMatcher == null) {
                        entityMatcher = XML_ENTITY_PATTERN.matcher(value);
                    }
                    entityMatcher.region(i, length);
                    if (entityMatcher.lookingAt()) {
                        filtered = value.substring(entityMatcher.start(), entityMatcher.end());
                        i += filtered.length() - 1;
                        if (result != null) break;
                        continue block7;
                    }
                    filtered = "&amp;";
                    break;
                }
                case '\"': {
                    filtered = "&quot;";
                    break;
                }
                case '\'': {
                    filtered = "&#39;";
                }
            }
            if (result == null) {
                if (filtered == null) continue;
                result = new StringBuilder(length + 50);
                if (i > 0) {
                    result.append(value.substring(0, i));
                }
                result.append(filtered);
                continue;
            }
            if (filtered == null) {
                result.append(value.charAt(i));
                continue;
            }
            result.append(filtered);
        }
        if (result == null) {
            string = value;
            return string;
        }
        string = result.toString();
        return string;
    }

    public static String encodeURL(String url) {
        return ResponseUtils.encodeURL(url, "UTF-8");
    }

    public static String encodeURL(String url, String enc) {
        String str = null;
        try {
            if (enc == null || enc.isEmpty()) {
                enc = "UTF-8";
            }
            str = URLEncoder.encode(url, enc);
        }
        catch (UnsupportedEncodingException e) {
            LOG.debug("The named encoding is not supported: {}", (Object)enc, (Object)e);
            try {
                str = URLEncoder.encode(url, Charset.defaultCharset().toString());
            }
            catch (UnsupportedEncodingException e1) {
                LOG.debug("The default-encoding is not supported: {}", (Object)enc, (Object)e1);
                str = url;
            }
        }
        return str;
    }
}

