/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.struts.config.MessageResourcesConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleUtils {
    private static final ModuleUtils instance = new ModuleUtils();
    private final Logger log = LoggerFactory.getLogger(ModuleUtils.class);

    protected ModuleUtils() {
    }

    public static ModuleUtils getInstance() {
        return instance;
    }

    public ModuleConfig getModuleConfig(HttpServletRequest request) {
        return (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE");
    }

    public ModuleConfig getModuleConfig(String prefix, ServletContext context) {
        if (prefix == null || "/".equals(prefix)) {
            return (ModuleConfig)context.getAttribute("org.apache.struts.action.MODULE");
        }
        return (ModuleConfig)context.getAttribute("org.apache.struts.action.MODULE" + prefix);
    }

    public ModuleConfig getModuleConfig(String prefix, HttpServletRequest request, ServletContext context) {
        ModuleConfig moduleConfig = null;
        moduleConfig = prefix != null ? this.getModuleConfig(prefix, context) : this.getModuleConfig(request, context);
        return moduleConfig;
    }

    public ModuleConfig getModuleConfig(HttpServletRequest request, ServletContext context) {
        ModuleConfig moduleConfig = this.getModuleConfig(request);
        if (moduleConfig == null) {
            moduleConfig = this.getModuleConfig("", context);
            request.setAttribute("org.apache.struts.action.MODULE", (Object)moduleConfig);
        }
        return moduleConfig;
    }

    public String getModuleName(HttpServletRequest request, ServletContext context) {
        String matchPath = (String)request.getAttribute("jakarta.servlet.include.servlet_path");
        if (matchPath == null) {
            matchPath = request.getServletPath();
        }
        return this.getModuleName(matchPath, context);
    }

    public String getModuleName(String matchPath, ServletContext context) {
        this.log.debug("Get module name for path {}", (Object)matchPath);
        String prefix = "";
        String[] prefixes = this.getModulePrefixes(context);
        int lastSlash = 0;
        block0: while (prefix.isEmpty() && (lastSlash = matchPath.lastIndexOf("/")) > 0) {
            matchPath = matchPath.substring(0, lastSlash);
            for (int i = 0; i < prefixes.length; ++i) {
                if (!matchPath.equals(prefixes[i])) continue;
                prefix = prefixes[i];
                continue block0;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Module name found: {}", (Object)(prefix.isEmpty() ? "default" : prefix));
        }
        return prefix;
    }

    public String[] getModulePrefixes(ServletContext context) {
        return (String[])context.getAttribute("org.apache.struts.globals.MODULE_PREFIXES");
    }

    public void selectModule(HttpServletRequest request, ServletContext context) {
        String prefix = this.getModuleName(request, context);
        this.selectModule(prefix, request, context);
    }

    public void selectModule(String prefix, HttpServletRequest request, ServletContext context) {
        ModuleConfig config = this.getModuleConfig(prefix, context);
        if (config != null) {
            request.setAttribute("org.apache.struts.action.MODULE", (Object)config);
            MessageResourcesConfig[] mrConfig = config.findMessageResourcesConfigs();
            for (int i = 0; i < mrConfig.length; ++i) {
                String key = mrConfig[i].getKey();
                MessageResources resources = (MessageResources)context.getAttribute(key + prefix);
                if (resources != null) {
                    request.setAttribute(key, (Object)resources);
                    continue;
                }
                request.removeAttribute(key);
            }
        } else {
            request.removeAttribute("org.apache.struts.action.MODULE");
        }
    }
}

