/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.upload;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MultipartRequestWrapper
extends HttpServletRequestWrapper {
    protected Map<String, String[]> parameters = new HashMap<String, String[]>();

    public MultipartRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public void setParameter(String name, String value) {
        String[] mValue = this.parameters.get(name);
        if (mValue == null) {
            mValue = new String[]{};
        }
        String[] newValue = new String[mValue.length + 1];
        System.arraycopy(mValue, 0, newValue, 0, mValue.length);
        newValue[mValue.length] = value;
        this.parameters.put(name, newValue);
    }

    public String getParameter(String name) {
        String[] mValue;
        String value = this.getRequest().getParameter(name);
        if (value == null && (mValue = this.parameters.get(name)) != null && mValue.length > 0) {
            value = mValue[0];
        }
        return value;
    }

    public Enumeration<String> getParameterNames() {
        Enumeration baseParams = this.getRequest().getParameterNames();
        ArrayList<String> list = new ArrayList<String>();
        while (baseParams.hasMoreElements()) {
            list.add((String)baseParams.nextElement());
        }
        Set<String> multipartParams = this.parameters.keySet();
        list.addAll(multipartParams);
        return Collections.enumeration(list);
    }

    public String[] getParameterValues(String name) {
        String[] value = this.getRequest().getParameterValues(name);
        if (value == null) {
            value = this.parameters.get(name);
        }
        return value;
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>(this.parameters);
        map.putAll(this.getRequest().getParameterMap());
        return map;
    }
}

