/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.upload;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileUploadByteCountLimitException;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.FileUploadFileCountLimitException;
import org.apache.commons.fileupload2.core.FileUploadSizeException;
import org.apache.commons.fileupload2.jakarta.JakartaServletFileUpload;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.upload.FormFile;
import org.apache.struts.upload.MultipartRequestHandler;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonsMultipartRequestHandler
implements MultipartRequestHandler {
    public static final long DEFAULT_SIZE_MAX = 0xFA00000L;
    public static final long DEFAULT_FILE_SIZE_MAX = 0xFA00000L;
    public static final long DEFAULT_MAX_STRING_LEN = 4096L;
    public static final int DEFAULT_SIZE_THRESHOLD = 262144;
    private final Logger log = LoggerFactory.getLogger(CommonsMultipartRequestHandler.class);
    private HashMap<String, Object> elementsAll;
    private HashMap<String, FormFile[]> elementsFile;
    private HashMap<String, String[]> elementsText;
    private ActionMapping mapping;
    private ActionServlet servlet;
    private static final boolean WIN_SYSTEM = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows");

    @Override
    public ActionServlet getServlet() {
        return this.servlet;
    }

    @Override
    public void setServlet(ActionServlet servlet) {
        this.servlet = servlet;
    }

    @Override
    public ActionMapping getMapping() {
        return this.mapping;
    }

    @Override
    public void setMapping(ActionMapping mapping) {
        this.mapping = mapping;
    }

    @Override
    public void handleRequest(HttpServletRequest request) throws ServletException {
        ModuleConfig ac = (ModuleConfig)request.getAttribute("org.apache.struts.action.MODULE");
        DiskFileItemFactory.Builder factory = DiskFileItemFactory.builder();
        factory.setBufferSize((int)this.getSizeThreshold(ac));
        factory.setFile(this.getRepositoryFile(ac));
        JakartaServletFileUpload upload = new JakartaServletFileUpload((FileItemFactory)factory.get());
        upload.setHeaderCharset(Charset.forName(request.getCharacterEncoding()));
        upload.setSizeMax(this.getSizeMax(ac));
        upload.setFileSizeMax(this.getFileSizeMax(ac));
        upload.setFileCountMax(this.getFileCountMax(ac));
        this.elementsText = new HashMap();
        this.elementsFile = new HashMap();
        this.elementsAll = new HashMap();
        List items = null;
        try {
            items = upload.parseRequest(request);
        }
        catch (FileUploadSizeException e) {
            request.setAttribute("org.apache.struts.upload.MaxLengthExceeded", (Object)Boolean.TRUE);
            if (e instanceof FileUploadByteCountLimitException) {
                FileUploadByteCountLimitException e2 = (FileUploadByteCountLimitException)e;
                request.setAttribute("org.apache.struts.upload.MaxByteLengthExceeded", (Object)Boolean.TRUE);
                this.log.warn("Byte-Count-Limit-Exception: FieldName: {}, FileName: {}, MaxSize: {}, CurrentSize: {}", new Object[]{e2.getFieldName(), e2.getFieldName(), e2.getPermitted(), e2.getActualSize(), e2});
            } else if (e instanceof FileUploadFileCountLimitException) {
                FileUploadFileCountLimitException e2 = (FileUploadFileCountLimitException)e;
                request.setAttribute("org.apache.struts.upload.MaxFileCountExceeded", (Object)Boolean.TRUE);
                this.log.warn("File-Count-Limit-Exception: MaxSize: {}, CurrentSize: {}", new Object[]{e2.getPermitted(), e2.getActualSize(), e2});
            } else {
                this.log.warn("Byte-Count-Limit-Exception: MaxSize: {}, CurrentSize: {}", new Object[]{e.getPermitted(), e.getActualSize(), e});
            }
            this.clearInputStream(request);
            return;
        }
        catch (FileUploadException e) {
            this.log.error("Failed to parse multipart request", (Throwable)e);
            this.clearInputStream(request);
            throw new ServletException((Throwable)e);
        }
        long maxStringLen = this.getMaxStringLen(ac);
        for (DiskFileItem item : items) {
            if (item.isFormField()) {
                this.addTextParameter(request, maxStringLen, (FileItem<?>)item);
                continue;
            }
            this.addFileParameter((FileItem<?>)item);
        }
    }

    @Override
    public HashMap<String, String[]> getTextElements() {
        return this.elementsText;
    }

    @Override
    public HashMap<String, FormFile[]> getFileElements() {
        return this.elementsFile;
    }

    @Override
    public HashMap<String, Object> getAllElements() {
        return this.elementsAll;
    }

    @Override
    public void rollback() {
        for (FormFile[] files : this.elementsFile.values()) {
            for (FormFile formFile : files) {
                try {
                    formFile.destroy();
                }
                catch (IOException e) {
                    this.log.atWarn().setMessage("Failed to destroy FormFile {}").addArgument((Object)formFile.getFileName()).setCause((Throwable)e).log();
                }
            }
        }
    }

    @Override
    public void finish() {
        this.rollback();
    }

    protected void clearInputStream(HttpServletRequest request) {
        if (WIN_SYSTEM) {
            try {
                ServletInputStream is = request.getInputStream();
                byte[] data = new byte[262144];
                int bytesRead = 0;
                while ((bytesRead = is.read(data)) > -1) {
                }
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected long getSizeMax(ModuleConfig mc) {
        return this.convertSizeToBytes("maximal request size", mc.getControllerConfig().getMaxSize(), 0xFA00000L);
    }

    protected long getFileSizeMax(ModuleConfig mc) {
        return this.convertSizeToBytes("maximal file size", mc.getControllerConfig().getMaxFileSize(), 0xFA00000L);
    }

    protected long getMaxStringLen(ModuleConfig mc) {
        return this.convertSizeToBytes("maximal string length", mc.getControllerConfig().getMaxStringLen(), 4096L);
    }

    protected long getSizeThreshold(ModuleConfig mc) {
        return this.convertSizeToBytes("threshold size", mc.getControllerConfig().getMemFileSize(), 262144L);
    }

    protected long convertSizeToBytes(String sizeType, String sizeString, long defaultSize) {
        int multiplier = 1;
        if (sizeString.endsWith("K")) {
            multiplier = 1024;
        } else if (sizeString.endsWith("M")) {
            multiplier = 0x100000;
        } else if (sizeString.endsWith("G")) {
            multiplier = 0x40000000;
        }
        if (multiplier != 1) {
            sizeString = sizeString.substring(0, sizeString.length() - 1);
        }
        long size = 0L;
        try {
            size = Long.parseLong(sizeString);
        }
        catch (NumberFormatException nfe) {
            this.log.warn("Invalid format for {} ('{}'). Using default.", (Object)sizeType, (Object)sizeString);
            size = defaultSize;
            multiplier = 1;
        }
        return size * (long)multiplier;
    }

    protected long getFileCountMax(ModuleConfig mc) {
        return mc.getControllerConfig().getFileCountMax();
    }

    protected File getRepositoryFile(ModuleConfig mc) {
        File tempDirFile = null;
        String tempDir = mc.getControllerConfig().getTempDir();
        if (tempDir == null || tempDir.isEmpty()) {
            ServletContext context;
            if (this.servlet != null && (tempDirFile = (File)(context = this.servlet.getServletContext()).getAttribute("jakarta.servlet.context.tempdir")) != null) {
                tempDirFile = tempDirFile.getAbsoluteFile();
            }
            if (tempDirFile == null) {
                tempDir = System.getProperty("java.io.tmpdir");
            }
        }
        if (tempDirFile == null && tempDir != null && !tempDir.isEmpty()) {
            tempDirFile = new File(tempDir);
        }
        this.log.trace("File upload temp dir: {}", tempDirFile);
        return tempDirFile;
    }

    protected void addTextParameter(HttpServletRequest request, long maxStringLen, FileItem<?> item) {
        String value;
        String name = item.getFieldName();
        if (item.getSize() > maxStringLen) {
            request.setAttribute("org.apache.struts.upload.MaxLengthExceeded", (Object)Boolean.TRUE);
            request.setAttribute("org.apache.struts.upload.MaxStringLengthExceeded", (Object)Boolean.TRUE);
            this.log.warn("Max-String-Length: FieldName: {}, FileName: {}, MaxSize: {}, CurrentSize: {}", new Object[]{item.getFieldName(), item.getFieldName(), maxStringLen, item.getSize()});
            value = "";
        } else {
            value = this.getTextValue(request, item);
        }
        if (request instanceof MultipartRequestWrapper) {
            MultipartRequestWrapper wrapper = (MultipartRequestWrapper)request;
            wrapper.setParameter(name, value);
        }
        this.elementsAll.put(name, CommonsMultipartRequestHandler.addElement(this.elementsText, name, value));
    }

    protected String getTextValue(HttpServletRequest request, FileItem<?> item) {
        Charset encoding = null;
        if (item instanceof DiskFileItem) {
            encoding = ((DiskFileItem)item).getCharset();
            this.log.debug("DiskFileItem.getCharset=[{}]", (Object)encoding);
        }
        if (encoding == null) {
            try {
                encoding = Charset.forName(request.getCharacterEncoding());
                this.log.debug("request.getCharacterEncoding=[{}]", (Object)encoding);
            }
            catch (UnsupportedCharsetException e) {
                this.log.warn("Unknown request.getCharacterEncoding", (Throwable)e);
            }
        }
        if (encoding != null) {
            try {
                return item.getString(encoding);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            return item.getString(StandardCharsets.ISO_8859_1);
        }
        catch (IOException e) {
            this.log.info("FileItem-getString", (Throwable)e);
            return item.getString();
        }
    }

    protected void addFileParameter(FileItem<?> item) {
        String name = item.getFieldName();
        CommonsFormFile value = new CommonsFormFile(item);
        this.elementsAll.put(name, CommonsMultipartRequestHandler.addElement(this.elementsFile, name, value));
    }

    private static <T> T[] addElement(HashMap<String, T[]> elements, String name, T value) {
        Object[] newArray;
        T[] oldArray = elements.get(name);
        if (oldArray != null) {
            newArray = Arrays.copyOf(oldArray, oldArray.length + 1);
        } else {
            Object[] array = (Object[])Array.newInstance(value.getClass(), 1);
            newArray = array;
        }
        newArray[newArray.length - 1] = value;
        elements.put(name, newArray);
        return newArray;
    }

    static class CommonsFormFile
    implements FormFile,
    Serializable {
        private static final long serialVersionUID = -6784594200973351263L;
        FileItem<?> fileItem;

        public CommonsFormFile(FileItem<?> fileItem) {
            this.fileItem = fileItem;
        }

        @Override
        public String getContentType() {
            return this.fileItem.getContentType();
        }

        @Override
        public void setContentType(String contentType) {
            throw new UnsupportedOperationException("The setContentType() method is not supported.");
        }

        @Override
        @Deprecated
        public int getFileSize() {
            long size = this.fileItem.getSize();
            if (size > Integer.MAX_VALUE) {
                throw new IllegalStateException("Size is greater than 2 GB; use getFileLength()");
            }
            return (int)size;
        }

        @Override
        @Deprecated
        public void setFileSize(int filesize) {
            throw new UnsupportedOperationException("The setFileSize() method is not supported.");
        }

        @Override
        public long getFileLength() {
            return this.fileItem.getSize();
        }

        @Override
        public void setFileLength(long fileLength) {
            throw new UnsupportedOperationException("The setFileLength() method is not supported.");
        }

        @Override
        public String getFileName() {
            return this.getBaseFileName(this.fileItem.getName());
        }

        @Override
        public void setFileName(String fileName) {
            throw new UnsupportedOperationException("The setFileName() method is not supported.");
        }

        @Override
        public byte[] getFileData() throws FileNotFoundException, IOException {
            return this.fileItem.get();
        }

        @Override
        public InputStream getInputStream() throws FileNotFoundException, IOException {
            return this.fileItem.getInputStream();
        }

        @Override
        public void destroy() throws IOException {
            this.fileItem.delete();
        }

        protected String getBaseFileName(String filePath) {
            String fileName = new File(filePath).getName();
            int colonIndex = fileName.indexOf(":");
            if (colonIndex == -1) {
                colonIndex = fileName.indexOf("\\\\");
            }
            int backslashIndex = fileName.lastIndexOf("\\");
            if (colonIndex > -1 && backslashIndex > -1) {
                fileName = fileName.substring(backslashIndex + 1);
            }
            return fileName;
        }

        public String toString() {
            return this.getFileName();
        }
    }
}

