/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.dispatcher.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.chain.contexts.ServletActionContext;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.dispatcher.AbstractMethodResolver;

public class ServletMethodResolver
extends AbstractMethodResolver {
    private static final long serialVersionUID = -4372320855532463910L;
    private static final Class<?>[] CLASSIC_EXECUTE_SIGNATURE = new Class[]{ActionMapping.class, ActionForm.class, HttpServletRequest.class, HttpServletResponse.class};

    @Override
    public Object[] buildArguments(ActionContext context, Method method) {
        Object[] args = super.buildArguments(context, method);
        if (args == null) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            switch (parameterTypes.length) {
                case 4: {
                    return this.buildClassicArguments((ServletActionContext)context);
                }
            }
        }
        return args;
    }

    protected final Object[] buildClassicArguments(ServletActionContext context) {
        ActionConfig mapping = context.getActionConfig();
        ActionForm form = context.getActionForm();
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        return new Object[]{mapping, form, request, response};
    }

    protected final Method resolveClassicMethod(ActionContext context, String methodName) throws NoSuchMethodException {
        Class<?> actionClass = context.getAction().getClass();
        return actionClass.getMethod(methodName, CLASSIC_EXECUTE_SIGNATURE);
    }

    @Override
    public Method resolveMethod(ActionContext context, String methodName) throws NoSuchMethodException {
        try {
            return super.resolveMethod(context, methodName);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (context instanceof ServletActionContext) {
                try {
                    Class<?> actionClass = context.getAction().getClass();
                    return actionClass.getMethod(methodName, ServletActionContext.class);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    // empty catch block
                }
            }
            return this.resolveClassicMethod(context, methodName);
        }
    }
}

