/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.dispatcher;

import org.apache.struts.action.ActionMapping;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.dispatcher.AbstractDispatcher;
import org.apache.struts.dispatcher.MethodResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMappingDispatcher
extends AbstractDispatcher {
    private static final long serialVersionUID = 1882936058355907522L;
    private final transient Logger log = LoggerFactory.getLogger(AbstractMappingDispatcher.class);
    private String defaultMappingParameter;

    public AbstractMappingDispatcher(MethodResolver methodResolver) {
        super(methodResolver);
        this.setDefaultMappingParameter("execute");
    }

    protected final String getDefaultMappingParameter() {
        return this.defaultMappingParameter;
    }

    @Override
    protected String resolveMethodName(ActionContext context) {
        ActionMapping mapping = (ActionMapping)context.getActionConfig();
        String parameter = mapping.getParameter();
        if ("".equals(parameter)) {
            parameter = null;
        }
        if (parameter == null) {
            parameter = this.defaultMappingParameter;
        }
        if (parameter == null) {
            String message = messages.getMessage("dispatcher.missingMappingParameter", (Object)mapping.getPath());
            this.log.error(message);
            throw new IllegalStateException(message);
        }
        return parameter;
    }

    protected final void setDefaultMappingParameter(String defaultMappingParameter) {
        this.defaultMappingParameter = defaultMappingParameter;
    }
}

