/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.dispatcher;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.struts.action.Action;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.dispatcher.Dispatcher;
import org.apache.struts.dispatcher.MethodResolver;
import org.apache.struts.util.MessageResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDispatcher
implements Dispatcher,
Serializable {
    private static final long serialVersionUID = 8527912438873600103L;
    static final String LOCAL_STRINGS = "org.apache.struts.dispatcher.LocalStrings";
    static final String MSG_KEY_DISPATCH_ERROR = "dispatcher.error";
    static final String MSG_KEY_MISSING_METHOD = "dispatcher.missingMethod";
    static final String MSG_KEY_MISSING_METHOD_LOG = "dispatcher.missingMethod.log";
    static final String MSG_KEY_MISSING_MAPPING_PARAMETER = "dispatcher.missingMappingParameter";
    static final String MSG_KEY_UNSPECIFIED = "dispatcher.unspecified";
    public static final String CANCELLED_METHOD_NAME = "cancelled";
    public static final String EXECUTE_METHOD_NAME = "execute";
    static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.dispatcher.LocalStrings");
    private final transient Logger log = LoggerFactory.getLogger(AbstractDispatcher.class);
    private final transient HashMap<String, Method> methods;
    private final MethodResolver methodResolver;

    public AbstractDispatcher(MethodResolver methodResolver) {
        this.methodResolver = methodResolver;
        this.methods = new HashMap();
    }

    Object[] buildMethodArguments(ActionContext context, Method method) {
        Object[] args = this.methodResolver.buildArguments(context, method);
        if (args == null) {
            throw new IllegalStateException("Unsupported method signature: " + method.toString());
        }
        return args;
    }

    @Override
    public Object dispatch(ActionContext context) throws Exception {
        Method method;
        String methodName = this.resolveMethodName(context);
        if (methodName == null || "".equals(methodName)) {
            methodName = this.getDefaultMethodName();
        }
        if (methodName == null) {
            return this.unspecified(context);
        }
        try {
            method = this.getMethod(context, methodName);
        }
        catch (NoSuchMethodException e) {
            String path = context.getActionConfig().getPath();
            if (this.log.isErrorEnabled()) {
                String message = messages.getMessage(MSG_KEY_MISSING_METHOD_LOG, (Object)path, (Object)methodName);
                this.log.error(message, (Throwable)e);
            }
            String userMsg = messages.getMessage(MSG_KEY_MISSING_METHOD, (Object)path);
            NoSuchMethodException e2 = new NoSuchMethodException(userMsg);
            e2.initCause(e);
            throw e2;
        }
        return this.dispatchMethod(context, method, methodName);
    }

    protected final Object dispatchMethod(ActionContext context, Method method, String name) throws Exception {
        Action target = context.getAction();
        String path = context.getActionConfig().getPath();
        Object[] args = this.buildMethodArguments(context, method);
        return this.invoke(target, method, args, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void flushMethodCache() {
        HashMap<String, Method> hashMap = this.methods;
        synchronized (hashMap) {
            this.methods.clear();
        }
    }

    protected String getDefaultMethodName() {
        return EXECUTE_METHOD_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Method getMethod(ActionContext context, String methodName) throws NoSuchMethodException {
        HashMap<String, Method> hashMap = this.methods;
        synchronized (hashMap) {
            StringBuilder keyBuf = new StringBuilder(100);
            keyBuf.append(context.getAction().getClass().getName());
            keyBuf.append(":");
            keyBuf.append(methodName);
            String key = keyBuf.toString();
            Method method = this.methods.get(key);
            if (method == null) {
                method = this.resolveMethod(context, methodName);
                this.methods.put(key, method);
            }
            return method;
        }
    }

    protected final Object invoke(Object target, Method method, Object[] args, String path) throws Exception {
        try {
            Class<Void> retval = method.invoke(target, args);
            if (method.getReturnType() == Void.TYPE) {
                retval = Void.TYPE;
            }
            return retval;
        }
        catch (IllegalAccessException e) {
            this.log.atError().setMessage("{}:{}").addArgument(() -> messages.getMessage(MSG_KEY_DISPATCH_ERROR, (Object)path)).addArgument((Object)method.getName()).setCause((Throwable)e).log();
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            this.log.atError().setMessage("{}:{}").addArgument(() -> messages.getMessage(MSG_KEY_DISPATCH_ERROR, (Object)path)).addArgument((Object)method.getName()).setCause((Throwable)e).log();
            throw new Exception(t);
        }
    }

    protected boolean isCancelled(ActionContext context) {
        Boolean cancelled = context.getCancelled();
        return cancelled != null && cancelled != false;
    }

    Method resolveMethod(ActionContext context, String methodName) throws NoSuchMethodException {
        return this.methodResolver.resolveMethod(context, methodName);
    }

    abstract String resolveMethodName(ActionContext var1);

    protected Object unspecified(ActionContext context) throws Exception {
        ActionConfig config = context.getActionConfig();
        String msg = messages.getMessage(MSG_KEY_UNSPECIFIED, (Object)config.getPath());
        this.log.error(msg);
        throw new IllegalStateException(msg);
    }
}

