/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionForward;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.util.WildcardHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionConfigMatcher
implements Serializable {
    private static final long serialVersionUID = -7803926870173575845L;
    private final transient Logger log = LoggerFactory.getLogger(ActionConfigMatcher.class);
    private static final WildcardHelper wildcard = new WildcardHelper();
    private ArrayList<Mapping> compiledPaths = new ArrayList();

    public ActionConfigMatcher(ActionConfig[] configs) {
        for (int x = 0; x < configs.length; ++x) {
            String path = configs[x].getPath();
            if (path == null || path.indexOf(42) <= -1) continue;
            if (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            this.log.debug("Compiling action config path '{}'", (Object)path);
            int[] pattern = wildcard.compilePattern(path);
            this.compiledPaths.add(new Mapping(pattern, configs[x]));
        }
    }

    public ActionConfig match(String path) {
        ActionConfig config = null;
        if (this.compiledPaths.size() > 0) {
            this.log.debug("Attempting to match '{}' to a wildcard pattern", (Object)path);
            if (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            HashMap<String, String> vars = new HashMap<String, String>();
            for (Mapping m : this.compiledPaths) {
                if (!wildcard.match(vars, path, m.getPattern())) continue;
                this.log.debug("Path matches pattern '{}'", (Object)m.getActionConfig().getPath());
                try {
                    config = this.convertActionConfig(path, m.getActionConfig(), vars);
                }
                catch (IllegalStateException e) {
                    this.log.warn("Path matches pattern '{}' but is incompatible with the matching config due to recursive substitution: {}", (Object)m.getActionConfig().getPath(), (Object)path);
                    config = null;
                }
            }
        }
        return config;
    }

    protected ActionConfig convertActionConfig(String path, ActionConfig orig, Map<String, String> vars) {
        ActionConfig config = null;
        try {
            config = (ActionConfig)BeanUtils.cloneBean((Object)orig);
        }
        catch (Exception ex) {
            this.log.warn("Unable to clone action config, recommend not using wildcards", (Throwable)ex);
            return null;
        }
        config.setName(this.convertParam(orig.getName(), vars));
        if (path.length() == 0 || path.charAt(0) != '/') {
            path = "/" + path;
        }
        config.setPath(path);
        config.setType(this.convertParam(orig.getType(), vars));
        config.setRoles(this.convertParam(orig.getRoles(), vars));
        config.setParameter(this.convertParam(orig.getParameter(), vars));
        config.setAttribute(this.convertParam(orig.getAttribute(), vars));
        config.setForward(this.convertParam(orig.getForward(), vars));
        config.setInclude(this.convertParam(orig.getInclude(), vars));
        config.setInput(this.convertParam(orig.getInput(), vars));
        config.setCatalog(this.convertParam(orig.getCatalog(), vars));
        config.setCommand(this.convertParam(orig.getCommand(), vars));
        config.setMultipartClass(this.convertParam(orig.getMultipartClass(), vars));
        config.setPrefix(this.convertParam(orig.getPrefix(), vars));
        config.setSuffix(this.convertParam(orig.getSuffix(), vars));
        ForwardConfig[] fConfigs = orig.findForwardConfigs();
        for (int x = 0; x < fConfigs.length; ++x) {
            ActionForward cfg;
            try {
                cfg = (ActionForward)BeanUtils.cloneBean((Object)fConfigs[x]);
            }
            catch (Exception ex) {
                this.log.warn("Unable to clone action config, recommend not using wildcards", (Throwable)ex);
                return null;
            }
            cfg.setName(fConfigs[x].getName());
            cfg.setPath(this.convertParam(fConfigs[x].getPath(), vars));
            cfg.setRedirect(fConfigs[x].getRedirect());
            cfg.setCommand(this.convertParam(fConfigs[x].getCommand(), vars));
            cfg.setCatalog(this.convertParam(fConfigs[x].getCatalog(), vars));
            cfg.setModule(this.convertParam(fConfigs[x].getModule(), vars));
            this.replaceProperties(fConfigs[x].getProperties(), cfg.getProperties(), vars);
            config.removeForwardConfig(fConfigs[x]);
            config.addForwardConfig(cfg);
        }
        this.replaceProperties(orig.getProperties(), config.getProperties(), vars);
        ExceptionConfig[] exConfigs = orig.findExceptionConfigs();
        for (int x = 0; x < exConfigs.length; ++x) {
            config.addExceptionConfig(exConfigs[x]);
        }
        config.freeze();
        return config;
    }

    protected void replaceProperties(Properties orig, Properties props, Map<String, String> vars) {
        for (Map.Entry<Object, Object> entry : orig.entrySet()) {
            props.setProperty((String)entry.getKey(), this.convertParam((String)entry.getValue(), vars));
        }
    }

    protected String convertParam(String val, Map<String, String> vars) {
        if (val == null) {
            return null;
        }
        if (val.indexOf("{") == -1) {
            return val;
        }
        StringBuilder key = new StringBuilder("{0}");
        StringBuilder ret = new StringBuilder(val);
        for (Map.Entry<String, String> entry : vars.entrySet()) {
            int x;
            key.setCharAt(1, entry.getKey().charAt(0));
            String keyStr = key.toString();
            if (entry.getValue().contains(keyStr)) {
                throw new IllegalStateException();
            }
            while ((x = ret.toString().indexOf(keyStr)) > -1) {
                ret.replace(x, x + 3, entry.getValue());
            }
        }
        return ret.toString();
    }

    private class Mapping
    implements Serializable {
        private static final long serialVersionUID = -4524356639556048603L;
        private int[] pattern;
        private ActionConfig config;

        public Mapping(int[] pattern, ActionConfig config) {
            this.pattern = pattern;
            this.config = config;
        }

        public int[] getPattern() {
            return this.pattern;
        }

        public ActionConfig getActionConfig() {
            return this.config;
        }
    }
}

