/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.commands.servlet;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.chain.commands.AbstractPopulateActionForm;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.chain.contexts.ServletActionContext;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.util.RequestUtils;

public class PopulateActionForm
extends AbstractPopulateActionForm {
    @Override
    protected void populate(ActionContext context, ActionConfig actionConfig, ActionForm actionForm) throws Exception {
        ServletActionContext saContext = (ServletActionContext)context;
        HttpServletRequest request = saContext.getRequest();
        RequestUtils.populate(actionForm, actionConfig.getPrefix(), actionConfig.getSuffix(), request);
    }

    @Override
    protected void reset(ActionContext context, ActionConfig actionConfig, ActionForm actionForm) {
        ServletActionContext saContext = (ServletActionContext)context;
        HttpServletRequest request = saContext.getRequest();
        actionForm.reset((ActionMapping)actionConfig, request);
        if (actionConfig.getMultipartClass() != null) {
            saContext.getRequestScope().put("org.apache.struts.action.mapping.multipartclass", actionConfig.getMultipartClass());
        }
    }

    @Override
    protected boolean isPopulate(ActionContext context, ActionConfig actionConfig) {
        String[] events = actionConfig.getPopulateNames();
        return this.getResetOrPopulate(context, events);
    }

    @Override
    protected boolean isReset(ActionContext context, ActionConfig actionConfig) {
        String[] events = actionConfig.getResetNames();
        return this.getResetOrPopulate(context, events);
    }

    private boolean getResetOrPopulate(ActionContext context, String[] events) {
        if (events == null || events.length == 0) {
            return true;
        }
        if (events.length == 1) {
            if (events[0].equals("all")) {
                return true;
            }
            if (events[0].equals("none")) {
                return false;
            }
        }
        HttpServletRequest request = ((ServletActionContext)context).getRequest();
        for (int i = 0; i < events.length; ++i) {
            String attribute = events[i];
            if (attribute.equals("forward")) {
                if (!RequestUtils.isRequestForwarded(request)) continue;
                return true;
            }
            if (attribute.equals("include")) {
                if (!RequestUtils.isRequestIncluded(request)) continue;
                return true;
            }
            if (attribute.equals("chain")) {
                if (!RequestUtils.isRequestChained(request)) continue;
                return true;
            }
            if (!attribute.equals("request") || RequestUtils.isRequestForwarded(request) || RequestUtils.isRequestIncluded(request)) continue;
            return true;
        }
        return false;
    }
}

