/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.commands.generic;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.Filter;
import org.apache.struts.chain.commands.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrappingLookupCommand
implements Filter<Context> {
    private final Logger log = LoggerFactory.getLogger(WrappingLookupCommand.class);
    private String catalogName = null;
    private String name = null;
    private String nameKey = null;
    private String wrapperClassName = null;
    private boolean optional = false;

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameKey() {
        return this.nameKey;
    }

    public void setNameKey(String nameKey) {
        this.nameKey = nameKey;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public String getWrapperClassName() {
        return this.wrapperClassName;
    }

    public void setWrapperClassName(String wrapperClassName) {
        this.wrapperClassName = wrapperClassName;
    }

    public boolean execute(Context context) throws Exception {
        this.log.trace("execute [{}]", (Object)this);
        Command<Context> command = this.getCommand(context);
        if (command != null) {
            return command.execute(this.getContext(context));
        }
        return false;
    }

    public boolean postprocess(Context context, Exception exception) {
        Command<Context> command = this.getCommand(context);
        if (command != null && command instanceof Filter) {
            try {
                Filter filter = (Filter)command;
                return filter.postprocess(this.getContext(context), exception);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                this.log.error("Error wrapping context in postprocess", (Throwable)ex);
            }
        }
        return false;
    }

    protected Command<Context> getCommand(Context context) {
        Catalog catalog;
        CatalogFactory catalogFactory = CatalogFactory.getInstance();
        String catalogName = this.getCatalogName();
        if (catalogName == null) {
            catalog = catalogFactory.getCatalog();
            catalogName = "{default}";
        } else {
            catalog = catalogFactory.getCatalog(catalogName);
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Cannot find catalog '" + catalogName + "'");
        }
        String name = this.getName();
        if (name == null) {
            name = (String)context.get((Object)this.getNameKey());
        }
        if (name != null) {
            this.log.debug("Lookup command {} in catalog {}", (Object)name, (Object)catalogName);
            Command command = catalog.getCommand(name);
            this.log.debug("Found command {}; optional: {}", (Object)command, (Object)this.isOptional());
            if (command == null && !this.isOptional()) {
                throw new IllegalArgumentException("Cannot find command '" + name + "' in catalog '" + catalogName + "'");
            }
            return command;
        }
        throw new IllegalArgumentException("No command name");
    }

    protected Context getContext(Context context) throws ClassNotFoundException, InstantiationException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        if (this.wrapperClassName == null) {
            this.log.debug("No defined wrapper class; returning original context.");
            return context;
        }
        this.log.debug("Looking for wrapper class: {}", (Object)this.wrapperClassName);
        Class<?> wrapperClass = ClassUtils.getApplicationClass(this.wrapperClassName);
        this.log.debug("Instantiating wrapper class");
        return (Context)ConstructorUtils.invokeConstructor(wrapperClass, (Object)context);
    }
}

