/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.commands;

import java.util.HashMap;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.chain.commands.ActionCommandBase;
import org.apache.struts.chain.commands.util.ClassUtils;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.dispatcher.Dispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteDispatcher
extends ActionCommandBase {
    private final Logger log = LoggerFactory.getLogger(ExecuteDispatcher.class);
    private String defaultDispatcherType;

    protected Dispatcher createDispatcher(String type, ActionContext context) throws Exception {
        this.log.info("Initializing dispatcher of type: {}", (Object)type);
        return (Dispatcher)ClassUtils.getApplicationInstance(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean execute_(ActionContext context) throws Exception {
        Boolean valid = context.getFormValid();
        if (valid == null || !valid.booleanValue()) {
            return false;
        }
        if (context.getAction() == null) {
            return false;
        }
        String dispatcherType = this.getDispatcherType(context);
        if (dispatcherType == null && (dispatcherType = this.defaultDispatcherType) == null) {
            return false;
        }
        String cacheKey = "dispatchers" + context.getModuleConfig().getPrefix();
        HashMap<String, Dispatcher> dispatchers = (HashMap<String, Dispatcher>)context.getApplicationScope().get(cacheKey);
        if (dispatchers == null) {
            dispatchers = new HashMap<String, Dispatcher>();
            context.getApplicationScope().put(cacheKey, dispatchers);
        }
        Dispatcher dispatcher = null;
        HashMap<String, Dispatcher> hashMap = dispatchers;
        synchronized (hashMap) {
            ActionConfig actionConfig = context.getActionConfig();
            String actionType = actionConfig.getType();
            dispatcher = (Dispatcher)dispatchers.get(actionType);
            if (dispatcher == null) {
                dispatcher = this.createDispatcher(dispatcherType, context);
                dispatchers.put(actionType, dispatcher);
            }
        }
        Object result = dispatcher.dispatch(context);
        this.processDispatchResult(result, context);
        return false;
    }

    public final String getDefaultDispatcherType() {
        return this.defaultDispatcherType;
    }

    protected String getDispatcherType(ActionContext context) {
        String dispatcherType = null;
        if (context != null) {
            dispatcherType = context.getActionConfig().getDispatcher();
        }
        return dispatcherType;
    }

    protected void processDispatchResult(Object result, ActionContext context) {
        if (result == null) {
            return;
        }
        if (result instanceof ForwardConfig) {
            context.setForwardConfig((ForwardConfig)result);
            return;
        }
        ActionConfig actionConfig = context.getActionConfig();
        ActionMapping mapping = (ActionMapping)actionConfig;
        if (result instanceof String) {
            context.setForwardConfig(mapping.findRequiredForward((String)result));
            return;
        }
        if (result == Void.TYPE) {
            context.setForwardConfig(mapping.findRequiredForward("success"));
            return;
        }
        throw new IllegalStateException("Unknown dispatch return type: " + result.getClass().getName());
    }

    public final void setDefaultDispatcherType(String defaultDispatcherType) {
        this.defaultDispatcherType = defaultDispatcherType;
    }
}

